% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stats_evalues.R
\name{stats_evalues}
\alias{stats_evalues}
\title{Statistics of environmental conditions in M and for occurrences (multiple variables)}
\usage{
stats_evalues(stats = c("median", "range"), M_folder, M_format, occ_folder,
  longitude, latitude, var_folder, var_format, round = FALSE, round_names,
  multiplication_factor = 1, percentage_out = 0, save = FALSE,
  output_directory, overwrite = FALSE)
}
\arguments{
\item{stats}{(character) name or vector of names of functions to be applied
to get basic statistics of environmental values.}

\item{M_folder}{(character) name of the folder containing files representing
the accessible area (M) for each species to be analyzed. See details.}

\item{M_format}{format of files representing the accessible area (M) for the
species. Names of M files must match the ones for occurrence files in
\code{occ_folder}. Format options are: "shp", "gpkg", or any of the options
in \code{\link[raster]{writeFormats}} (e.g., "GTiff").}

\item{occ_folder}{(character) name of the folder containing csv files of
occurrence data for all species. Names of csv files must match the ones of M
files in \code{M_folder}.}

\item{longitude}{(character) name of the column in occurrence files containing
values of longitude.}

\item{latitude}{(character) name of the column in occurrence files containing
values of latitude.}

\item{var_folder}{(character) name of the folder containing layers to
represent environmental variables.}

\item{var_format}{format of layers to represent environmental variables. See
options in \code{\link[raster]{writeFormats}} (e.g., "GTiff").}

\item{round}{(logical) whether or not to round the values of one or more
variables after multiplying them times the value in \code{multiplication_factor}.
Default = FALSE. See details.}

\item{round_names}{(character) names of the variables to be rounded.
Default = NULL. If \code{round} = TRUE, names must be defined.}

\item{multiplication_factor}{(numeric) value to be used to multiply the
variables defined in \code{round_names}. Default = 1.}

\item{percentage_out}{(numeric) percentage of extreme environmental data in M
to be excluded in bin creation for further analyses. See details. Default = 0.}

\item{save}{(logical) whether or not to save the results in working directory.
Default = FALSE.}

\item{output_directory}{(character) name of the folder in which results will
be written.}

\item{overwrite}{(logical) whether or not to overwrite existing results in
\code{output_directory}. Default = FALSE.}
}
\value{
A list named as the variables present in \code{var_folder}, containing all
tables with statistics of environmental values in M and in species records.
A folder named as in \code{output_directory} containing all resultant csv
files with the tables of statistics will be created if \code{save} is set as
TRUE.
}
\description{
stats_evalues helps in creating csv files with statistics
of environmental conditions in accessible areas (M) and species occurrence
records. This is done using data read directly from a local directory, and
can be applied to various species and multiple variables.
}
\details{
Coordinates in csv files in \code{occ_folder}, SpatialPolygons*-like files in
\code{M_folder}, and raster layers in \code{var_folder} must coincide in the
geographic projection in which they are represented. WGS84 with no planar
projection is recommended.

Accessible area (M) is understood as the geographic area that has been
accessible for a species for relevant periods of time. Defining M is usually
a hard task, but also a very important one, because it allows identifying
uncertainties about the ability of a species to maintain populations in
certain environmental conditions. For further details on this topic, see
Barve et al. (2011) in \url{https://doi.org/10.1016/j.ecolmodel.2011.02.011}.

Rounding variables may be useful when multiple variables are considered and
the values of some or all of them are too small (e.g., when using principal
components). To round specific variables arguments \code{round},
\code{round_names}, and \code{multiplication_factor}, must be used accordingly.

The percentage to be defined in \code{percentage_out} excludes a percentage
of extreme environmental values to prevent the algorithm from considering
extremely rare environmental values in the accessible area for the species (M).
Being too rare, these values may have never been explored by the species;
therefore, including them in the process of preparation of the table of
characters (bin table) is risky.
}
\examples{
# example of how to define arguments, check argument descriptions above
\donttest{
stats <- stats_evalues(stats = c("median", "range"), M_folder = "Folder_with_Ms",
                       M_format = "shp", occ_folder = "Folder_with_occs",
                       longitude = "lon_column", latitude = "lat_column",
                       var_folder = "Folder_with_vars", var_format = "GTiff",
                       percentage_out = 0)
}
}
