% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dLogisticGrowth.R
\name{dLogisticGrowth}
\alias{dLogisticGrowth}
\alias{rLogisticGrowth}
\title{Logistic Growth Model}
\usage{
dLogisticGrowth(x, a, b, k, r, log)

rLogisticGrowth(n, a, b, k, r)
}
\arguments{
\item{x}{vector of calendar years (in BP).}

\item{a}{lower (earliest) limit of the distribution (in BP).}

\item{b}{upper (latest) limit of the distribution (in BP).}

\item{k}{initial proportion of the carrying capacity (must be between 0 and 1).}

\item{r}{intrinsic growth rate.}

\item{log}{TRUE or 1 to return log probability. FALSE or 0 to return probability.}

\item{n}{number of random draws. Currently only n = 1 is supported, but the argument exists for standardization of "r" functions.}
}
\value{
For \code{dLogisticGrowth}: the probability (or likelihood) or log probability of an observed date x (in Cal BP). For \code{rLogisticGrowth} a simulated date in Cal BP.
}
\description{
Density and random generation of a logistic growth model distribution.
}
\examples{
p = list(k=0.01,r=0.007)
modelPlot(model = dLogisticGrowth,a=6000,b=4000,params=p,alpha = 1)
}
\author{
Enrico Crema
}
