% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/postPredSPD.R
\name{postPredSPD}
\alias{postPredSPD}
\title{SPD-based Posterior Predictive Check}
\usage{
postPredSPD(
  x,
  errors,
  calCurve,
  model,
  a,
  b,
  params,
  nsim,
  method = NULL,
  spdnormalised = TRUE,
  datenormalised = TRUE,
  ncores = 1,
  verbose = TRUE
)
}
\arguments{
\item{x}{a vector of observed uncalibrated radiocarbon ages.}

\item{errors}{a vector of standard deviations corresponding to each estimated radiocarbon age.}

\item{calCurve}{character string naming a calibration curve already provided with the rcarbon package (currently 'intcal20','intcal13','intcal13nhpine16','shcal20','shcal13','shcal13shkauri16',''marine13','marine20').}

\item{model}{growth model}

\item{a}{lower (earliest) limit of the distribution (in BP).}

\item{b}{upper (latest) limit of the distribution (in BP).}

\item{params}{list of vectors containing model parameters. The names attribute of each vector should match growth model parameters.}

\item{nsim}{number of SPDs to be generated.  Default is the length of the parameter vectors supplied in the argument \code{params}.}

\item{method}{method for the creation of random dates from the fitted model. Either 'uncalsample' or 'calsample'.}

\item{spdnormalised}{a logical variable indicating whether the total probability mass of the SPD is normalised to sum to unity for both observed and simulated data. Default is TRUE.}

\item{datenormalised}{a logical variable indicating whether dates should be normalised to sum to unity or not. Default is TRUE.}

\item{ncores}{number of cores used for for parallel execution. Default is 1.}

\item{verbose}{a logical variable indicating whether extra information on progress should be reported. Default is TRUE.}
}
\value{
An object of class \code{spdppc} with the following elements
\itemize{
\item{\code{obs}} {A data.frame containing the years (in Cal BP) and the corresponding summed probability in the observed data.}
\item{\code{spdmat}} {A matrix containing the summed probability distribution of the simulated data.}
}
}
\description{
Generates SPDs from posterior samples.
}
