% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dHabitatMask.R
\name{dHabitatMask}
\alias{dHabitatMask}
\alias{rHabitatMask}
\title{Ones trick distribution for irregular habitat shapes}
\usage{
dHabitatMask(x, s, xmax, xmin, ymax, ymin, habitatMask, log = 0)

rHabitatMask(n, s, xmax, xmin, ymax, ymin, habitatMask)
}
\arguments{
\item{x}{Ones trick data.}

\item{s}{Bivariate activity center coordinates.}

\item{xmax}{Maximum of trap location x-coordinates.}

\item{xmin}{Minimum of trap location x-coordinates.}

\item{ymax}{Maximum of trap location y-coordinates.}

\item{ymin}{Minimum of trap location y-coordinates.}

\item{habitatMask}{A binary matrix object indicating which cells are considered as suitable habitat.}

\item{log}{Logical argument, specifying whether to return the log-probability of the distribution.}

\item{n}{Integer specifying the number of realisations to generate.  Only n = 1 is supported.}
}
\value{
The log-likelihood value associated with the bivariate activity center location s being in the suitable habitat
(i.e. 0 if it falls within the habitat mask and -Inf otherwise).
}
\description{
The dHabitatMask distribution checks and ensures that the proposed activity center location (s) falls
within the suitable habitat (defined in the binary matrix habitatMask).
}
\details{
The rHabitatMask function returns the value of the habitat mask cell (0 or 1) where the proposed activity center falls. 
See also \href{http://mikemeredith.net/blog/1309_SECR_in_JAGS_patchy_habitat.htm}{M. Meredith: SECR in BUGS/JAGS with patchy habitat}.
}
\examples{
## define model code
code <- nimbleCode({
    for(i in 1:N) {
        s[i, 1] ~ dunif(0, 100)
        s[i, 2] ~ dunif(0, 100)
        OK[i] ~ dHabitatMask( s = s[i,1:2],
                              xmax = 100,
                              xmin = 0,
                              ymax = 100,
                              ymin = 0,
                              habitatMask = habitatMask[1:100,1:100])
    }
})
 
N <- 20
 
habitatMask <- matrix(rbinom(10000,1,0.75), nrow = 100)
 
constants <- list(N = N, habitatMask = habitatMask)
 
data <- list(OK = rep(1, N))
 
inits <- list(s = array(runif(2*N, 0, 100), c(N,2)))
 
## create NIMBLE model object
Rmodel <- nimbleModel(code, constants, data, inits)
 
## use model object for MCMC, etc.

}
\author{
Daniel Turek
}
