% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addPdokTiles.R
\name{addPdokTiles}
\alias{addPdokTiles}
\title{Leaflet function to add pdok tiles}
\usage{
addPdokTiles(map, type = c("brt", "aerial", "pastel", "gray"),
  group = match.arg(type), ...)
}
\arguments{
\item{map}{leaflet object}

\item{type}{one of the PDOK tiles: currently: "brt", "aerial", "pastel" or "gray"}

\item{group}{group is set equal to type}

\item{...}{Passed to \code{\link[leaflet]{addTiles}}.}
}
\description{
This function adds PDOK tile layers to \code{\link[leaflet]{leaflet}}.
It is a small wrapper around \code{\link[leaflet]{addTiles}} that sets
the correct urls for the layers.
}
\details{
PDOK provides tiles that can be used as a tile layer in several
geovisualization tools including \code{leaflet}.
The layers differ from other tile layers such as Openstreetmap, Google and
cartomap in the following manner:
\itemize{
  \item The tiles are restricted to the Netherlands: tiles accross the Dutch
  border are "grayed out". This is useful for cartographic applications
  that are restricted to Dutch geo-information.
  \item The tiles are open source and based on open sourced geo-information.
}
}
