% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nlmixr.R
\name{nlmixr_fit}
\alias{nlmixr_fit}
\title{Fit a nlmixr model}
\usage{
nlmixr_fit(uif, data, est = "nlme", control = list(), ...,
  sum.prod = FALSE, calc.resid = TRUE)
}
\arguments{
\item{uif}{Parsed nlmixr model (by \code{nlmixr(mod.fn)}).}

\item{data}{Dataset to estimate.  Needs to be RxODE compatible in
EVIDs.}

\item{est}{Estimation method}

\item{control}{Estimation control options.  They could be
\code{\link[nlme]{nlmeControl}}, \code{\link{saemControl}}}

\item{...}{Parameters passed to estimation method.}

\item{sum.prod}{Take the RxODE model and use more precise
products/sums.  Increases solving accuracy and solving time.}

\item{calc.resid}{Translate the model to FOCEi and then run
the tables and objective function so that different estimation
methodologies are comparable through OBJF.}
}
\value{
nlmixr fit object
}
\description{
Fit a nlmixr model
}
\author{
Matthew L. Fidler
}
