% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/timing.R
\name{nlmixrAddTiming}
\alias{nlmixrAddTiming}
\title{Manually add time to a nlmixr2 object}
\usage{
nlmixrAddTiming(object, name, time)
}
\arguments{
\item{object}{nlmixr2 object}

\item{name}{string of the timing name}

\item{time}{time (in seconds)}
}
\value{
Nothing, called for side effects
}
\description{
Manually add time to a nlmixr2 object
}
\examples{

\donttest{

one.cmt <- function() {
 ini({
   ## You may label each parameter with a comment
   tka <- 0.45 # Ka
   tcl <- log(c(0, 2.7, 100)) # Log Cl
   ## This works with interactive models
   ## You may also label the preceding line with label("label text")
   tv <- 3.45; label("log V")
   ## the label("Label name") works with all models
   eta.ka ~ 0.6
   eta.cl ~ 0.3
   eta.v ~ 0.1
   add.sd <- 0.7
 })
 model({
   ka <- exp(tka + eta.ka)
   cl <- exp(tcl + eta.cl)
   v <- exp(tv + eta.v)
   linCmt() ~ add(add.sd)
 })
}

fit <- nlmixr(one.cmt, theo_sd, est="saem")

# will add to the current setup
nlmixrAddTiming(fit, "setup", 3)

# Add a new item to the timing dataframe
nlmixrAddTiming(fit, "new", 3)

}

}
\author{
Matthew L. Fidler
}
