test_that("covariate assert", {

  d <-
  data.frame(
    id = c(1L, 1L, 1L, 1L, 1L, 1L, 1L, 2L, 2L, 2L, 2L, 2L, 2L, 2L),
    dv = c(0.850250173832214, 2.2203333886695, 1.45986377167887, 1.50582966162175, 1.49919474792279, 1.31236634006289, 1.81834559737199,
           0.956430954650681, 0.927455141558561, 0.789397894990653, 0.74022224812602,
           1.08951691866523, 0.792652901422078, 0.62527472582842),
    evid = 0,
    time = 1,
    AVAL = c(0, 1.17190642542115, 0.972067914421224, 0.625595969986141, 0.469365853946905, 0.311158440430677,
             0.227985190831196, 0, 0, 0, 0, 0, 0, 0))

  mod <- function() {
    ini({
      le0 = log(10)
      lemax = log(25)
      lec50 = log(2)
      iiv_e0 ~ 0.1
      sd_prop <- 0.2
    })
    model({
      e0_i <- exp(le0 + iiv_e0)
      emax_i <- exp(lemax)
      ec50 <- exp(lec50)
      eff <- e0 + emax_i * AVAL/(ec50 + AVAL)
      eff ~ prop(sd_prop)
    })
  }

  expect_error(nlmixr(mod, d, est = "focei"),
               "'e0'")

})
