% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{boxCox}
\alias{boxCox}
\alias{iBoxCox}
\alias{yeoJohnson}
\alias{iYeoJohnson}
\title{Cox Box, Yeo Johnson and inverse transformation}
\usage{
boxCox(x, lambda = 1)

iBoxCox(x, lambda = 1)

yeoJohnson(x, lambda = 1)

iYeoJohnson(x, lambda = 1)
}
\arguments{
\item{x}{data to transform}

\item{lambda}{Cox-box lambda parameter}
}
\value{
Cox-Box Transformed Data
}
\description{
Cox Box, Yeo Johnson and inverse transformation
}
\examples{

boxCox(1:3,1) ## Normal
iBoxCox(boxCox(1:3,1))

boxCox(1:3,0) ## Log-Normal
iBoxCox(boxCox(1:3,0),0)

boxCox(1:3,0.5) ## lambda=0.5
iBoxCox(boxCox(1:3,0.5),0.5)

yeoJohnson(seq(-3,3),1) ## Normal
iYeoJohnson(yeoJohnson(seq(-3,3),1))

yeoJohnson(seq(-3,3),0)
iYeoJohnson(yeoJohnson(seq(-3,3),0),0)
}
\author{
Matthew L. Fidler
}
