\name{parInfer.WM}
\alias{parInfer.WM}
\title{
  WM-estimate Inference
}
\description{
  Parameter inference for weighted M-estimate. WM-estimate is based on minimizing the robustified form of likelihood, simultanously over nonlinear function parameter and variance model parameters the the covariance of parameter, the estimate is assymptotically normal (See Lim et al.2010) with given covariance matric which compute for sample by the function.
}
\usage{
parInfer.WM(object, confidence = 0.95)
}
\arguments{
  \item{object}{
    \code{\link{nl.fitt.rgn}} object of WM-fitt generated by \code{\link{nl.robhetroWM}} function.
}
  \item{confidence}{
    Confidence probability.
}
}
\details{
  Compute covariance matrix and confidence interval for nonlinear model function parameter and nonlinear variance model parameters. 
}
\value{
  \item{covmat:}{Covariance matrix of nonlinear model function parameters.}
  \item{covtau}{Covariance matrix of nonlinear variance model parameters.}
  \item{parstdev}{Standard deviation of nonlinear model function parameter. It is square root of diagonal of \code{covmat}.}
  \item{CI}{Confidence interval for nonlinear model function parameter.}
}
\references{
Lim, C., Sen, P. K., Peddada, S. D. (2010). Statistical inference in nonlinear regression under heteroscedasticity. Sankhya B 72:202-218.
}
\author{
    Hossein Riazoshams, May 2014. 
  Email: \email{riazihosein@gmail.com} 
  URL \url{http://www.riazoshams.com/nlr/}
}
\note{
  \code{ParInfer} method of \code{\link{nl.fitt.rgn}} call this function automatically, so user might not call it directly.
  
  This function call by \code{\link{nlr}}, for compatibility it is better to call from \code{\link{nlr}} rather than directly by user.
}
\seealso{
  \code{\link{nl.fitt.rgn}}, \code{\link{nl.robhetroWM}} 
}
\examples{
## The function is currently defined as
"parInfer.WM"
}
\keyword{Weighted M-estimate}
\keyword{Robust estimators}
\keyword{Maximum Likelihood}

