% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nlsLMList.R
\name{nlsLMList}
\alias{nlsLMList}
\title{Create a list of nls objects with the option of using nlsLM in addition to nls}
\usage{
nlsLMList(
  model,
  data,
  start,
  control,
  level,
  subset,
  na.action = na.fail,
  algorithm = c("LM", "default", "port", "plinear"),
  pool = TRUE,
  warn.nls = NA
)
}
\arguments{
\item{model}{either a nonlinear model formula, with the response on the left of a ~ operator and an expression involving parameters, covariates, and a grouping factor separated by the | operator on the right, or a selfStart function.}

\item{data}{a data frame}

\item{start}{list with starting values}

\item{control}{control list, see \code{\link{nls}}}

\item{level}{an optional integer specifying the level of grouping to be used when multiple nested levels of grouping are present.}

\item{subset}{subset of rows to use}

\item{na.action}{a function that indicates what should happen when the data contain NAs. The default action (na.fail) causes nlsList to print an error message and terminate if there are any incomplete observations.}

\item{algorithm}{choice of algorithm. Default is 'LM' which uses 'nlsLM' from the \CRANpkg{minpack.lm} package. Other options are: \dQuote{default}, \dQuote{port} and \dQuote{plinear} (nls).}

\item{pool}{an optional logical value that is preserved as an attribute of the returned value. This will be used as the default for pool in calculations of standard deviations or standard errors for summaries.}

\item{warn.nls}{logical indicating if nls errors (all of which are caught by tryCatch) should be signalled as a “summarizing” warning.}
}
\description{
This function is a copy of 'nlsList' from the 'nlme' package modified
to use the 'nlsLM' function in addition to (optionally) 'nls'. By changing the algorithm argument it is possible
to use 'nls' as well
}
\details{
See function \code{\link[nlme]{nlsList}} and \code{\link[minpack.lm]{nlsLM}}. This function is a copy of nlsList but with minor changes to use LM instead as the default algorithm. The authors of the original function are Pinheiro and Bates.
}
\author{
Jose C. Pinheiro and Douglas M. Bates \email{bates@stat.wisc.edu} wrote the original \code{\link[nlme]{nlsList}}. Fernando E. Miguez made minor changes to use \code{\link[minpack.lm]{nlsLM}} in addition to (optionally) \code{\link{nls}}. R-Core maintains copyright after 2006.
}
