% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/000generate.R
\docType{data}
\name{dataM}
\alias{dataM}
\title{Example dataset}
\format{
A data frame containing:
\describe{
  \item{Student}{Identification number for each student}
  \item{Gender}{0=Female, 1=Male}
  \item{PSATM}{PSAT score in Math}
  \item{SATM}{SAT score in Math}
  \item{ACTM}{ACT Score in Math}
  \item{Rank}{Adjusted rank in HS class}
  \item{Size}{Number of students in HS class}
  \item{GPAadj}{Adjusted GPA}
  \item{PlcmtScore}{Score on math placement exam}
  \item{Recommends}{Recommended course: R0 R01 R1 R12 R2 R3 R4 R6 R8}
  \item{Course}{Actual course taken}
  \item{Grade}{Course grade}
  \item{RecTaken}{1=recommended course, 0=otherwise}
  \item{TooHigh}{1=took course above recommended, 0=otherwise}
  \item{TooLow}{1=took course below recommended, 0=otherwise}
  \item{CourseSuccess}{1=B or better grade, 0=grade below B}
  \item{DR_Course}{according to recommendations, which level of course was taken: alow - lower, bnormal - recommended, chigh - higher}
}
}
\usage{
data(dataM)
}
\description{
Data "MathPlacement" taken from Stat2Data package.
}
\details{
Code for data modifications can be found in the example section.
}
\examples{
\donttest{
data(dataM)
library(magrittr)
library(dplyr)
if (requireNamespace("recipes", quietly = TRUE)&requireNamespace("Stat2Data", quietly = TRUE)) {
data("MathPlacement", package="Stat2Data")
head(MathPlacement)
library(recipes)
# As some of the data is missing, k-nearest neighbors (knn) imputation is 
# used to fill the gaps. This is done with recipes package and function 
# step_knnimpute.
dataM <- recipe(~ ., data = MathPlacement) \%>\%
step_knnimpute(everything()) \%>\% prep() \%>\% juice()
# Afterwards we create a categorical variable that will show whether a 
# student took a course which was too high, too low, the recommended one or
# something else happened:
dataM \%<>\% mutate(Student = 1:n(), DR_Course = case_when(
TooHigh == 1 ~ "chigh",
TooLow == 1 ~ "alow",
RecTaken == 1 ~ "bnormal",
TRUE ~"dother"
)) 
# We remove observations with ambiguous course status:
dataM \%<>\% filter(DR_Course!="dother")
dataM \%>\% select(DR_Course) \%>\% table \%>\% t 
}
}
}
\keyword{datasets}
