% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CLIP.confint_difflevel.R
\name{CLIP.confint.difflevel}
\alias{CLIP.confint.difflevel}
\title{Combine confidence interval for \code{logistf} after multiple imputation}
\usage{
CLIP.confint.difflevel(
  obj = NULL,
  variable = NULL,
  data,
  firth = TRUE,
  weightvar = NULL,
  control = logistf.control(),
  ci.level = c(0.025, 0.975),
  pvalue = TRUE,
  offset = NULL,
  bound.lo = NULL,
  bound.up = NULL,
  legacy = FALSE
)
}
\arguments{
\item{obj}{Either a list of logistf fits (on multiple imputed data sets), or the result of analysis of a \code{mice} (multiply imputed) object using \code{with.mids}}

\item{variable}{Must be used to include variables of interest; each of
variable of interest must have the same levels across different imputed
data sets.}

\item{data}{A list of data set corresponding to the model fits. Can be left blank if obj was obtained with the \code{dataout=TRUE} option or if obj was obtained by mice}

\item{firth}{If \code{TRUE}, applies the Firth correction. Should correspond to the entry in obj.}

\item{weightvar}{An optional weighting variable for each observation.}

\item{control}{Control parameters for \code{logistf}, usually obtained by \code{logistf.control()}}

\item{ci.level}{The two confidence levels for each tail of the posterior distribution.}

\item{pvalue}{If \code{TRUE}, will also compute a P-value from the posterior.}

\item{offset}{An optional offset variable}

\item{bound.lo}{Bounds (vector of length 2) for the lower limit. Can be left blank. Use only if problems are encountered.}

\item{bound.up}{Bounds (vector of length 2) for the upper limit. Can be left blank. Use only if problems are encountered.}

\item{legacy}{If \code{TRUE}, will use pure R code for all model fitting. Can be slow. Not recommended.}
}
\value{
An object of class \code{CLIP.confint}, with items:
   \item{variable}{The variable(s) which were analyzed}
   \item{estimate}{The pooled estimate (average over imputations)}
   \item{ci}{The confidence interval(s)}
   \item{pvalue}{The p-value(s)}
   \item{imputations}{The number of imputed datasets}
   \item{ci.level}{The confidence level (input)}
   \item{bound.lo}{The bounds used for finding the lower confidence limit; usually not of interest. May be useful for error-tracing.}
   \item{bound.up}{The bounds used for finding the upper confidence limit}
   \item{iter}{The number of iterations (for each variable and each tail)}
   \item{call}{The call object}
}
\description{
The function was modified from \code{[CLIP.confint](https://CRAN.R-project.org/package=logistf/index.html])} to combine
results from m imputed data sets that have different structures (e.g., a
covariate in a model have different levels across different imputed data
sets) on April 15, 2022.
}
\details{
The formula in \code{[logistf](https://CRAN.R-project.org/package=logistf/index.html])} must be written as variable of
interest followed by covariates that have different levels across different
imputed data sets.

For more information, please refer to the vignette using
\code{browseVignettes("nncc")} and the original function
\code{[CLIP.confint](https://CRAN.R-project.org/package=logistf/index.html])}.

Please cite the original function \code{[CLIP.confint](https://CRAN.R-project.org/package=logistf/index.html])} for
publication.
}
