% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_threshold.R
\name{get_threshold}
\alias{get_threshold}
\title{Identify the right threshold}
\usage{
get_threshold(data, vars, case_var = "case", p_threshold = 0.5, seed = 1600)
}
\arguments{
\item{data}{The dataset}

\item{vars}{The variables to use for calculating distance}

\item{case_var}{The name of the case identifier variable}

\item{p_threshold}{The probability that the closest matching approach
produces the closer matching relative to the random matching approach.
The greater \code{p_threshold}, the smaller the threshold.}

\item{seed}{A random seed.}
}
\value{
A list with items:
   \item{threshold}{The numeric threshold chosen}
   \item{modeldata}{The data used to fit the logistic regression model}
   \item{strata}{The strata made by make_knn_strata}
   \item{model}{The fit logisitic regression model}
}
\description{
To find a threshold for distance to define controls that are qualified to be
matched with a case.
}
\details{
This function uses logistic regression to predict by the
  distance whether a control is the closest (unique) match for each case vs.
  a random selection and by default returns the 50% threshold

  For more information, please refer to the vignette using
  \code{browseVignettes("nncc")}.
}
