% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NNCTFunctions.r
\name{exact.pval1s}
\alias{exact.pval1s}
\title{\eqn{p}-value correction to the one-sided version of exact NNCT test}
\usage{
exact.pval1s(ptable, pval, type = "inc")
}
\arguments{
\item{ptable}{Probability of the observed \eqn{2 \times 2} NNCT under the null hypothesis using the hypergeometric distribution
for Fisher's exact test.}

\item{pval}{Table inclusive \eqn{p}-value for Fisher's exact test on the NNCT.}

\item{type}{The type of the \eqn{p}-value correction for the one-sided exact test on the NNCT, default=\code{"inc"}.
Takes on values \code{"inc"}, \code{"exc"}, \code{"mid"}, \code{"tocher"} (or equivalently \code{1-4}, respectively) for table inclusive,
table-exclusive, mid-\eqn{p}-value, and Tocher corrected \eqn{p}-value, respectively.}
}
\value{
A modified \eqn{p}-value based on the correction specified in \code{type}.
}
\description{
In using Fisher's exact test on the \eqn{2 \times 2} nearest neighbor contingency tables (NNCTs) a correction
may be needed for the \eqn{p}-value. For the one-sided alternatives, the probabilities of 
more extreme tables are summed up, including or excluding the 
probability of the table itself (or some middle way). 
Let the probability of the contingency table itself be \eqn{p_t=f(n_{11}|n_1,n_2,c_1;\theta_0)}
where \eqn{\theta_0=(n_1-1)(n_2-1)/(n_1 n_2)} which is the odds ratio
under RL or CSR independence and
\eqn{f} is the probability mass function of the hypergeometric distribution.
For testing the one-sided alternative \eqn{H_o:\,\theta=\theta_0} versus \eqn{H_a:\,\theta>\theta_0},
we consider the following four methods in calculating the \eqn{p}-value:
\itemize{
\item [(i)] with \eqn{S=\{t:\,t \geq n_{11}\}}, we get the
\emph{table-inclusive version} which is denoted as \eqn{p^>_{inc}},
\item [(ii)] with \eqn{S=\{t:\,t> n_{11}\}}, we get the
\emph{table-exclusive version}, denoted as \eqn{p^>_{exc}}.
\item [(iii)] Using \eqn{p=p^>_{exc}+p_t/2}, we get the \emph{mid-\eqn{p} version}, denoted as \eqn{p^>_{mid}}.
\item [(iv)] We can also use \emph{Tocher corrected version} which is denoted as \eqn{p^>_{Toc}}
(see \code{\link{tocher.cor}} for details).
}

See (\insertCite{ceyhan:exact-NNCT;textual}{nnspat}) for more details.
}
\examples{
ct<-matrix(sample(20:40,4),ncol=2)
ptab<-prob.nnct(ct)
pv<-.3
exact.pval1s(ptab,pv)
exact.pval1s(ptab,pv,type="exc")
exact.pval1s(ptab,pv,type="mid")

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{exact.pval2s}} and \code{\link{tocher.cor}}
}
\author{
Elvan Ceyhan
}
