% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NNCTFunctions.r
\name{funsZnnsym2cl.dx}
\alias{funsZnnsym2cl.dx}
\alias{Znnsym2cl.dx.ct}
\alias{Znnsym2cl.dx}
\title{Dixon's NN Symmetry Test with Normal Approximation for Two Classes}
\usage{
Znnsym2cl.dx.ct(
  ct,
  Q,
  R,
  alternative = c("two.sided", "less", "greater"),
  conf.level = 0.95
)

Znnsym2cl.dx(
  dat,
  lab,
  alternative = c("two.sided", "less", "greater"),
  conf.level = 0.95,
  ...
)
}
\arguments{
\item{ct}{A nearest neighbor contingency table, used in \code{Znnsym2cl.dx.ct} only}

\item{Q}{The number of shared NNs, used in \code{Znnsym2cl.dx.ct} only}

\item{R}{The number of reflexive NNs (i.e., twice the number of reflexive NN pairs),
used in \code{Znnsym2cl.dx.ct} only}

\item{alternative}{Type of the alternative hypothesis in the test, one of \code{"two.sided"}, \code{"less"} or \code{"greater"}.}

\item{conf.level}{Level of the upper and lower confidence limits, default is \code{0.95}, 
for the difference of the off-diagonal entries, \eqn{N_{12}-N_{21}}}

\item{dat}{The data set in one or higher dimensions, each row corresponds to a data point,
used in \code{Znnsym2cl.dx} only}

\item{lab}{The \code{vector} of class labels (numerical or categorical), used in \code{Znnsym2cl.dx} only}

\item{\dots}{are for further arguments, such as \code{method} and \code{p}, passed to the \code{\link[stats]{dist}} function.
used in \code{Znnsym2cl.dx} only}
}
\value{
A \code{list} with the elements
\item{statistic}{The \eqn{Z} test statistic for Pielou's first type of NN symmetry test}
\item{p.value}{The \eqn{p}-value for the hypothesis test for the corresponding alternative}
\item{conf.int}{Confidence interval for the difference of the off-diagonal entries, \eqn{N_{12}-N_{21}} in the \eqn{2 \times 2} NNCT
at the given confidence level \code{conf.level} and depends on the type of \code{alternative}.}
\item{estimate}{Estimate, i.e., the difference of the off-diagonal entries of the \eqn{2 \times 2} NNCT, \eqn{N_{12}-N_{21}}.}
\item{null.value}{Hypothesized null value for the expected difference between the off-diagonal entries, 
\eqn{E(N_{12})-E(N_{21})} in the \eqn{2 \times 2} NNCT, which is 0 for this function.}
\item{alternative}{Type of the alternative hypothesis in the test, one of \code{"two.sided"}, \code{"less"}, \code{"greater"}}
\item{method}{Description of the hypothesis test}
\item{data.name}{Name of the data set, \code{dat}, or name of the contingency table, \code{ct}}
}
\description{
Two functions: \code{Znnsym2cl.dx.ct} and \code{Znnsym2cl.dx}.

Both functions are objects of class \code{"htest"} but with different arguments (see the parameter list below).
Each one performs the hypothesis test of equality of the expected value of the off-diagonal 
cell counts (i.e., entries) under RL or CSR in the NNCT for \eqn{k=2} classes.
That is, each performs Dixon's NN symmetry test which is appropriate 
(i.e. have the appropriate asymptotic sampling distribution)
for completely mapped data.
(See \insertCite{ceyhan:SWJ-spat-sym2014;textual}{nnspat} for more detail).

Each symmetry test is based on the normal approximation of the difference of the off-diagonal entries
in the NNCT and are due to \insertCite{dixon:1994;textual}{nnspat}.

Each function yields the test statistic, \eqn{p}-value for the
corresponding alternative, the confidence interval, estimate and null value for the parameter of interest
(which is the difference of the off-diagonal entries in the NNCT), and method and name of the data set used.

The null hypothesis is that all \eqn{E(N_{12})=E(N_{21})} in the \eqn{2 \times 2} NNCT (i.e., symmetry in the 
mixed NN structure).

See also
(\insertCite{dixon:1994,ceyhan:SWJ-spat-sym2014;textual}{nnspat})
and the references therein.
}
\examples{
n<-20  #or try sample(1:20,1)
Y<-matrix(runif(3*n),ncol=3)
ipd<-ipd.mat(Y)
cls<-sample(1:2,n,replace = TRUE)  #or try cls<-rep(1:2,c(10,10))
ct<-nnct(ipd,cls)
ct

W<-Wmat(ipd)
Qv<-Qvec(W)$q
Rv<-Rval(W)

Znnsym2cl.dx(Y,cls)
Znnsym2cl.dx.ct(ct,Qv,Rv)

Znnsym2cl.dx(Y,cls,method="max")

Znnsym2cl.dx(Y,cls,alt="g")
Znnsym2cl.dx.ct(ct,Qv,Rv,alt="g")

#cls as a factor
na<-floor(n/2); nb<-n-na
fcls<-rep(c("a","b"),c(na,nb))
Znnsym2cl.dx(Y,fcls)

#############
ct<-matrix(sample(1:20,4),ncol=2)
Znnsym2cl.dx.ct(ct,Qv,Rv) #gives an error message if ct<-matrix(sample(1:20,9),ncol=3)
#here, Qv and Rv values are borrowed from above, to highlight a point

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{Znnsym2cl.ss.ct}}, \code{\link{Znnsym2cl.ss}}, \code{\link{Znnsym.dx.ct}},
\code{\link{Znnsym.dx}}, \code{\link{Xsq.nnsym.dx.ct}} and \code{\link{Xsq.nnsym.dx}}
}
\author{
Elvan Ceyhan
}
