% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NNCTFunctions.R
\name{exact.nnct}
\alias{exact.nnct}
\title{Exact version of Pearson's chi-square test on NNCTs}
\usage{
exact.nnct(
  ct,
  alternative = "two.sided",
  conf.level = 0.95,
  pval.type = "inc",
  double = FALSE
)
}
\arguments{
\item{ct}{A \eqn{2 \times 2} NNCT}

\item{alternative}{Type of the alternative hypothesis in the test, one of \code{"two.sided"}, \code{"less"} or \code{"greater"}.}

\item{conf.level}{Level of the upper and lower confidence limits, default is \code{0.95}, 
for the odds ratio}

\item{pval.type}{The type of the \eqn{p}-value correction for the exact test on the NNCT, default=\code{"inc"}.
Takes on values \code{"inc"}, \code{"exc"}, \code{"mid"}, \code{"tocher"} (or equivalently \code{1-4}, respectively) for table inclusive,
table-exclusive, mid-\eqn{p}-value, and Tocher corrected \eqn{p}-value, respectively.}

\item{double}{A logical argument (default is \code{FALSE}) to determine whether type I or II correction should be 
applied to the two-sided \eqn{p}-value. Used only when \code{alternative="two.sided"}. 
If \code{TRUE} type I correction (for doubling the minimum of the one-sided \eqn{p}-value) 
is applied, otherwise, type II correction (using the probabilities for the more extreme tables) is applied.}
}
\value{
A \code{list} with the elements
\item{statistic}{The test statistic, it is \code{NULL} for this function}
\item{p.value}{The \eqn{p}-value for the hypothesis test for the corresponding alternative}
\item{conf.int}{Confidence interval for the odds ratio in the \eqn{2 \times 2} NNCT
at the given confidence level \code{conf.level} and depends on the type of \code{alternative}.}
\item{estimate}{Estimate, i.e., the observed odds ratio the \eqn{2 \times 2} NNCT.}
\item{null.value}{Hypothesized null value for the odds ratio in the \eqn{2 \times 2} NNCT, which is
\eqn{\theta_0=(n_1-1)(n_2-1)/(n_1 n_2)} for this function.}
\item{alternative}{Type of the alternative hypothesis in the test, one of \code{"two.sided"}, \code{"less"}, \code{"greater"}}
\item{method}{Description of the hypothesis test}
\item{data.name}{Name of the contingency table, \code{ct}}
}
\description{
An object of class \code{"htest"} performing exact version of Pearson's chi-square test on nearest neighbor contingency
tables (NNCTs) for the RL or CSR independence for 2 classes.
Pearson's \eqn{\chi^2} test is based on the test statistic 
\eqn{\mathcal X^2=\sum_{j=1}^2\sum_{i=1}^2 (N_{ij}-\mu_{ij})^2/\mu_{ij}},
which has \eqn{\chi^2_1} distribution in the limit provided
that the contingency table is constructed under the independence null hypothesis.
The exact version of Pearson's test uses the exact distribution of \eqn{\mathcal X^2} rather than large sample 
\eqn{\chi^2} approximation.
That is, for the one-sided alternative, we calculate
the \eqn{p}-values as in the function \code{\link{exact.pval1s}};
and for the two-sided alternative, we calculate
the \eqn{p}-values as in the function \code{\link{exact.pval2s}} with double argument determining
the type of the correction. 

This test would be equivalent to Fisher's exact test \code{\link[stats]{fisher.test}} if the odds ratio=1
(which can not be specified in the current version), and the odds ratio for the RL or CSR independence null
hypothesis is \eqn{\theta_0=(n_1-1)(n_2-1)/(n_1 n_2)} which is used in the function and
the \eqn{p}-value and confidence interval computations are are adapted from \code{\link[stats]{fisher.test}}.

See \insertCite{ceyhan:SWJ-spat-sym2014;textual}{nnspat} for more details.
}
\examples{
n<-20
Y<-matrix(runif(3*n),ncol=3)
ipd<-ipd.mat(Y)
cls<-sample(1:2,n,replace = TRUE)  #or try cls<-rep(1:2,c(10,10))
ct<-nnct(ipd,cls)
ct

exact.nnct(ct)
fisher.test(ct)

exact.nnct(ct,alt="g")
fisher.test(ct,alt="g")

exact.nnct(ct,alt="l",pval.type = "mid")

#############
ct<-matrix(sample(10:20,9),ncol=3)
fisher.test(ct) #here exact.nnct(ct) gives error message, since number of classes > 2

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link[stats]{fisher.test}}, \code{\link{exact.pval1s}}, and \code{\link{exact.pval2s}}
}
\author{
Elvan Ceyhan
}
