% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NNCTFunctions.R
\name{sharedNNmc}
\alias{sharedNNmc}
\title{The Shared NN Vectors for Multiple Classes}
\usage{
sharedNNmc(x, lab, is.ipd = TRUE, ...)
}
\arguments{
\item{x}{The IPD matrix (if \code{is.ipd=TRUE}) or a data set of points in matrix or data frame form where points
correspond to the rows (if \code{is.ipd = FALSEALSE}).}

\item{lab}{The \code{vector} of class labels (numerical or categorical)}

\item{is.ipd}{A logical parameter (default=\code{TRUE}). If \code{TRUE}, \code{x} is taken as the inter-point distance
matrix (IPD matrix), otherwise, \code{x} is taken as the data set with rows representing the data points.}

\item{\dots}{are for further arguments, such as \code{method} and \code{p}, passed to the \code{\link[stats]{dist}} function.}
}
\value{
\code{Qval} returns the \eqn{Q} value
\code{Qvec} returns a \code{list} with two elements
 \item{q}{the \eqn{Q} value, the number of shared NNs}
 \item{qvec}{the \code{vector} of \eqn{Q_j} values} 
\code{sharedNN} returns a \code{matrix} with 2 rows, where first row is the \eqn{j} values and second row is
the corresponding vector of \eqn{Q_j} values
\code{Rval}{the \eqn{R} value, the number of reflexive NNs}

Returns a \code{list} with two elements
 \item{Nv}{A \eqn{k}-row matrix of shared NNs by class where each row of the matrix is the vector of number of
 points with shared NNs \eqn{Q_i=(Q_{i0},Q_{i1},\ldots)} where \eqn{Q_{ij}} is the number of class \eqn{i} points that are NN
 to \eqn{j} points.}
 \item{col.ind}{The \code{vector} of indices of columns with nonzero sums}
}
\description{
Returns a \code{matrix} with \eqn{k} rows where each row is the vector of number of points with shared NNs,
\eqn{Q_i=(Q_{i0},Q_{i1},\ldots)} where \eqn{Q_{ij}} is the number of class \eqn{i} points that are NN to class \eqn{j} points.
The function also returns the indices of columns with nonzero sums as a vector.

The output matrix of shared NNs is used in testing symmetry in shared NN structure (i.e. \eqn{Q}-symmetry
or Pielou's second type of symmetry), 
e.g., in functions \code{\link{Qsym.ct}} and \code{\link{Qsym.test}}.

See also
(\insertCite{pielou:1961,ceyhan:SWJ-spat-sym2014;textual}{nnspat})
and the references therein.
}
\examples{
n<-20  #or try sample(1:20,1)
Y<-matrix(runif(3*n),ncol=3)
cls<-sample(1:2,n,replace = TRUE)  #or try cls<-rep(1:2,c(10,10))
ipd<-ipd.mat(Y)

sharedNNmc(ipd,cls)
sharedNNmc(Y,cls,is.ipd = FALSE)
sharedNNmc(Y,cls,is.ipd = FALSE,method="max")

#cls as a factor
na<-floor(n/2); nb<-n-na
fcls<-rep(c("a","b"),c(na,nb))
sharedNNmc(ipd,fcls)

#############
n<-40
Y<-matrix(runif(3*n),ncol=3)
cls<-sample(1:4,n,replace = TRUE)  #or try cls<-rep(1:2,c(10,10))
ipd<-ipd.mat(Y)

sharedNNmc(ipd,cls) 

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{Qval}}, \code{\link{Qvec}} and \code{\link{sharedNN}}
}
\author{
Elvan Ceyhan
}
