% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exists.R
\name{docdb_exists}
\alias{docdb_exists}
\title{Check if container exists in database}
\usage{
docdb_exists(src, key, ...)
}
\arguments{
\item{src}{Source object, result of call to any of functions
\code{\link[=src_mongo]{src_mongo()}}, \code{\link[=src_sqlite]{src_sqlite()}}, \code{\link[=src_elastic]{src_elastic()}} or \code{\link[=src_couchdb]{src_couchdb()}}}

\item{key}{(character) A key as name of the container
(corresponds to parameter \code{collection} for MongoDB,
\code{dbname} for CouchDB, \code{index} for Elasticsearch and to
a table name for SQLite)}

\item{...}{Passed to functions:
\itemize{
\item MongoDB: find() in \code{\link[mongolite:mongo]{mongolite::mongo()}}
\item RSQLite: \code{\link[DBI:dbListTables]{DBI::dbListTables()}}
\item Elasticsearch: \code{\link[elastic:indices]{elastic::index_exists()}}
\item CouchDB: \code{\link[sofa:db_info]{sofa::db_info()}}
}}
}
\value{
(logical) \code{TRUE} or \code{FALSE} to indicate
existence of container \code{key} in database
}
\description{
Check if container exists in database
}
\examples{
\dontrun{
src <- src_sqlite()
docdb_exists(src, "nonexistingcontainer")
docdb_create(src, "mtcars", mtcars)
docdb_exists(src, "mtcars")
}

}
