% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/update.R
\name{docdb_update}
\alias{docdb_update}
\title{Update documents}
\usage{
docdb_update(src, key, value, query, ...)
}
\arguments{
\item{src}{Source object, result of call to any of functions
\code{\link[=src_mongo]{src_mongo()}}, \code{\link[=src_sqlite]{src_sqlite()}}, \code{\link[=src_elastic]{src_elastic()}}, \code{\link[=src_couchdb]{src_couchdb()}}
\code{\link[=src_duckdb]{src_duckdb()}} or \code{\link[=src_postgres]{src_postgres()}}}

\item{key}{(character) The name of the container in the
database backend
(corresponds to \code{collection} for MongoDB,
\code{dbname} for CouchDB, \code{index} for Elasticsearch and to
a table name for DuckDb, SQLite and PostgreSQL)}

\item{value}{The data to be created in the database:
a single data.frame, a JSON string, a list,
or a file name or URL that points to NDJSON documents}

\item{query}{(character) A JSON query string to
identify the documents that should be updated
(patched) with \code{value},
Can use comparisons / tests (e.g., '$gt', '$ne', '$in', '$regex'),
with at most one logic operator ('$and' if not specified, or '$or'),
see examples below and in \code{\link[=docdb_query]{docdb_query()}}.}

\item{...}{Passed on to functions:
\itemize{
\item CouchDB: \code{\link[sofa:db_bulk_create]{sofa::db_bulk_create()}}
\item Elasticsearch: \code{\link[elastic:docs_bulk_update]{elastic::docs_bulk_update()}}
\item MongoDB: \code{\link[mongolite:mongo]{mongolite::mongo()}}
\item SQLite: ignored
\item PostgreSQL: ignored
\item DuckDB: ignored
}}
}
\value{
(integer) Number of successfully updated documents
}
\description{
Documents are updated by patching their JSON with
\code{value}.
Documents are identified by the \code{query} or
by \verb{_id}'s in \code{value}, where the latter takes
precedence.
\code{value} can have multiple documents and \verb{_id}'s,
which then are used for iterative updating.
}
\details{
Uses native functions with MongoDB, SQLite, DuckDB
and Elasticsearch; a \code{plpgsql} function added to
PostgreSQL; and \link{jqr} for CouchDB.
}
\examples{
\dontrun{
src <- src_sqlite()
docdb_create(src, "mtcars", mtcars)
docdb_update(src, "mtcars", value = mtcars[3, 4:5], query = '{"gear": 3}')
docdb_update(src, "mtcars", value = '{"carb":999}', query = '{"gear": 5}')
docdb_update(src, "mtcars", value = '{"_id":"Fiat 128", "carb":888}', query = '{}')
docdb_get(src, "mtcars")
}
}
