% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/noegletal_tidy.R
\name{noegletal_tidy}
\alias{noegletal_tidy}
\title{Transform a csv file from noegletal.dk into a tidy tibble}
\usage{
noegletal_tidy(file)
}
\arguments{
\item{file}{Path to a csv file downloaded from noegletal.dk.}
}
\value{
A tidy \code{\link[tibble:tibble]{tibble::tibble()}} with one row for each municipality-year,
and one column for each included variable (nøgletal).
}
\description{
\code{noegletal_tidy} takes as input a csv-file downloaded from noegletal.dk and
parses it into a tidy \code{\link[tibble:tibble]{tibble::tibble()}}. This \code{\link[tibble:tibble]{tibble::tibble()}} has one row
for each municipality-year, a \code{muni_code} column, a \code{year} column and a
column for each \code{variable} (as selected on noegletal.dk).

As per the noegletal.dk documentation, cells with a dash \code{-} as a value is
converted to a 0, while cells with a value of \code{M} or \code{U} is converted to
\code{NA}, since these represent missing values.
}
\examples{
path_to_file <- system.file("extdata",
                            "nwRap-10Sep2024-101803.csv",
                            package = "noegletalR",
                            mustWork = TRUE)
noegletal_tidy(file = path_to_file)
}
