% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_threshold_noise.R
\name{calculate_threshold_noise}
\alias{calculate_threshold_noise}
\title{Function to calculate the noise threshold for a given expression matrix}
\usage{
calculate_threshold_noise(
  expression.matrix,
  abn.matrix = NULL,
  dist.matrix = NULL,
  dist.thresh = 0.25,
  binsize = 0.1,
  dump.stats = NULL,
  method.chosen = NULL
)
}
\arguments{
\item{expression.matrix}{expression matrix, should be the one used in calculate_distance_matrices()}

\item{abn.matrix, dist.matrix}{the input distance and abundance matrices as calculated by
calculate_distance_matrices(); if either is not supplied, only a fixed threshold is
calculated based on the density}

\item{dist.thresh}{correlation threshold to be used to find corresponding abundance threshold.
The default, 0.25 is usually suitable for the Pearson correlation (the default method)}

\item{binsize}{size of each bin in the boxplot methods; defaults to 0.1 (on a log-scale)}

\item{dump.stats}{name of csv to export different thresholds calculated (optional)}

\item{method.chosen}{method to use to obtain a single vector of thresholds,
must be one of get_methods_calculate_noise_threshold();
if set, it skips all other methods; this is meant for speed, to be used internally or if rerunning
an analysis and is not recommended as a first approach.}
}
\value{
Normal output is a tibble containing information on thresholds calculated using different
methods (returned silently and optionally written in a csv file).
If method.chosen is set to one of the methods in get_methods_calculate_noise_threshold(),
then the output is a vector of noise thresholds,
the same length as the number of columns in the expression matrix.
}
\description{
This function is used to calculate the noise threshold for a given expression matrix.
It uses as input a distance matrix and the corresponding abundance matrix.
A variety of methods are available to obtain an abundance threshold using an input distance threshold.
}
\examples{
obj <- calculate_distance_matrices_counts(
    expression.matrix = matrix(1:100, ncol=5),
    method="correlation_pearson",
    n.elements.per.window=3)
calculate_threshold_noise(obj$exp, obj$abn, obj$dist,
    method.chosen="Boxplot-IQR")
}
