% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geo_lite.R
\name{geo_lite}
\alias{geo_lite}
\title{Geocode addresses}
\usage{
geo_lite(
  address,
  lat = "lat",
  long = "lon",
  limit = 1,
  full_results = FALSE,
  return_addresses = TRUE,
  verbose = FALSE,
  custom_query = list()
)
}
\arguments{
\item{address}{single line address (i.e. \code{"1600 Pennsylvania Ave NW, Washington"}) or a vector of addresses (\code{c("Madrid", "Barcelona")}).}

\item{lat}{latitude column name (i.e. \code{"lat"}).}

\item{long}{longitude column name (i.e. \code{"long"}).}

\item{limit}{maximum number of results to return per input address. Note
that each query returns a maximum of 50 results.}

\item{full_results}{returns all available data from the geocoding service if TRUE.
If FALSE (default) then only latitude and longitude columns are returned from the geocoding service.}

\item{return_addresses}{return input addresses with results if TRUE. Note that
most services return the input addresses with \code{full_results = TRUE} and setting
return_addresses to FALSE does not prevent this.}

\item{verbose}{if TRUE then detailed logs are output to the console. FALSE is default. Can be set
permanently with \code{options(tidygeocoder.verbose = TRUE)}}

\item{custom_query}{API-specific parameters to be used, passed as a named
list (i.e. \code{list(countrycodes = "US")}). See Details.}
}
\value{
A \code{tibble} with the results.
}
\description{
Geocodes addresses given as character values.
}
\details{
See \url{https://nominatim.org/release-docs/latest/api/Search/} for additional
parameters to be passed to \code{custom_query}.
}
\examples{
\dontshow{if (nominatim_check_access()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\donttest{
geo_lite("Madrid, Spain")

# Several addresses
geo_lite(c("Madrid", "Barcelona"))

# With options: restrict search to USA
geo_lite(c("Madrid", "Barcelona"),
  custom_query = list(countrycodes = "US"),
  full_results = TRUE
)
}
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=geo_lite_sf]{geo_lite_sf()}}, \code{\link[tidygeocoder:geo]{tidygeocoder::geo()}}

Other geocoding: 
\code{\link{geo_address_lookup}()},
\code{\link{geo_amenity}()},
\code{\link{reverse_geo_lite}()}
}
\concept{geocoding}
