% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nomnoml.R
\name{nomnoml}
\alias{nomnoml}
\title{Render nomnoml diagram.}
\usage{
nomnoml(
  code = "[Hello]-[World!]",
  png = NULL,
  width = NULL,
  height = NULL,
  svg = FALSE,
  ...
)
}
\arguments{
\item{code}{The nomnoml diagram code.}

\item{png}{Optional file name to export diagram as 'png'.}

\item{width}{Optional width in pixels for the exported 'png'.}

\item{height}{Optional height in pixels for the exported 'png'.}

\item{svg}{Use 'svg' output instead of 'png'? Notice that rendering in
'svg' is not at a par with 'png' and renders incorrectly at times.}

\item{...}{Additional parameters.}
}
\description{
\ifelse{html}{\out{<a href='https://www.tidyverse.org/lifecycle/#experimental'><img src='figures/lifecycle-experimental.svg' alt='Experimental lifecycle'></a>}}{\strong{Experimental}}

Renders a 'nomnoml' diagram as an 'htmlwidget' or saves it
as a 'png' image.
}
\details{
The 'nomnoml' syntax is simple and intuitive, a "Hello World"
example can be rendered as an 'htmlwidget' as follows:

\code{nomnoml::nomnoml("[Hello]-[World!]")}

You can also render as a 'png' file with specific dimensions:

\code{nomnoml::nomnoml("[Hello]-[World!]", png = "hello.png", 600, 100)}

Still, complex diagrams can be defined by combining multiple
association types, classifier types, directives and
custom classifier styles.

You can also use of the \code{nomnoml} 'knitr' chunk
to render inline diagrams in R Markdown documents.
}
\section{Syntax}{


For a summary of available \code{nomnoml} syntax, including association types,
directives and customer classifier styles, see \link{nomnoml_syntax}
}

\examples{
# Render simple diagram:
nomnoml::nomnoml("[Hello]-[World!]")

# Render complex diagram:
nomnoml::nomnoml("
  #stroke: #a86128
  [<frame>Decorator pattern|
    [<abstract>Component||+ operation()]
    [Client] depends --> [Component]
    [Decorator|- next: Component]
    [Decorator] decorates -- [ConcreteComponent]
    [Component] <:- [Decorator]
    [Component] <:- [ConcreteComponent]
  ]")

}
\seealso{
\code{\link[=nomnomlOutput]{nomnomlOutput()}}, \code{\link[=renderNomnoml]{renderNomnoml()}}, \code{\link[=nomnoml_validate]{nomnoml_validate()}}
}
