% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validate.R
\name{nomnoml_validate}
\alias{nomnoml_validate}
\title{Use the \code{V8} JavaScript engine to validate a \code{nomnoml} diagram.}
\usage{
nomnoml_validate(diagram = "[test]")
}
\arguments{
\item{diagram}{A \code{nomnoml} diagram to validate}
}
\value{
Either TRUE or FALSE
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

Although the \code{nomnoml} widgets render very quickly in the IDE, it can take a
few seconds to grab a static screenshot and create a \code{png} file.  In these
situations it can be helpful to validate if the \code{nomnoml} JS library can
parse a diagram.

This function returns \code{TRUE} if a diagram can be parsed, and \code{FALSE}
otherwise.  If \code{FALSE} the function also throws a warning.
}
\examples{
\dontrun{
if (requireNamespace("V8", quietly = TRUE)) nomnoml_validate("[hello] -> [world]")
}

}
\seealso{
\code{\link[=nomnoml]{nomnoml()}}
}
