% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prob_cal.R
\name{prob_cal}
\alias{prob_cal}
\title{Calculate Probabilities}
\usage{
prob_cal(reg, times)
}
\arguments{
\item{reg}{regression results after lrm(), cph() or psm() in 'rms' package.}

\item{times}{if you want to calculate probabilities for lrm() function, please left times missing.}
}
\value{
lieaner predictors and probabilities as a dataframe
}
\description{
Use Survival() function from 'rms' pacakge to calculate probabilities after lrm(), cph() or psm() regression. If you want to calculate lrm() probabilities, please leave linear.predictors be TRUE and times be missing. If you want to calculate cph() probabilites, please leave both linear.predictors and surv be TRUE.
}
\examples{
set.seed(2018)
n <-2019
age <- rnorm(n,60,20)
sex <- factor(sample(c('female','male'),n,TRUE))
sex <- as.numeric(sex)
weight <- sample(50:100,n,replace = TRUE)
time <- sample(50:800,n,replace = TRUE)
units(time)="day"
death <- sample(c(1,0,0),n,replace = TRUE)
df <- data.frame(time,death,age,sex,weight)

library(rms) #needed for lrm(), cph() and psm()
# lrm() function
f <- lrm(death~sex+age+weight,data=df,
         linear.predictors = TRUE)
head(prob_cal(reg = f))

# cph() function
f <- cph(Surv(time,death)~sex+age+weight,data=df,
         linear.predictors=TRUE,surv=TRUE)
head(prob_cal(reg = f,times = c(365,365*2)))

# psm() function
f <- psm(Surv(time,death)~sex+age+weight,data=df)
head(prob_cal(reg = f,times = c(365,365*2)))
}
