% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/04_GOFs.R
\name{do.cat.GOF}
\alias{do.cat.GOF}
\title{Y vs categorical X GOF-plot}
\usage{
do.cat.GOF(data, x, y, color = "", add.points = TRUE,
  refline = c("abline", "href0", "hrefmean", "hrefmedian", "none"),
  title = "", lines.by.id = FALSE, id.column = "ID", fx = NULL,
  fy = NULL, control = GOF.control())
}
\arguments{
\item{data}{data.frame to plot}

\item{x}{character string with name of column for x}

\item{y}{character string with name of column for y}

\item{color}{data columns to set different colors in plot, interpreted as factor}

\item{add.points}{add jittered points of data (TRUE), or not (FALSE)}

\item{refline}{add reference line with intercept=0, slope=1 (abline), horizontal at y=0( href0), horizontal at y=mean of y( hrefmean), horizontal at y=median of y( hrefmedian), or don't add reference line (none)}

\item{title}{title}

\item{lines.by.id}{connect subjects by lines (TRUE), or don't (FALSE)}

\item{id.column}{column name that indicate subject identifier}

\item{fx}{function for transformation of x before plotting}

\item{fy}{function for transformation of y before plotting}

\item{control}{an optional list of control settings. See GOF.control for the names of the settable control values and their effect.}
}
\description{
GOF plot with boxplots of Y grouped by categorical data in X, with refline and with caption added as reurned by get.caption
}
