% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.R
\name{comments.model}
\alias{comments.model}
\title{Extract Comments from Model}
\usage{
\method{comments}{model}(
  x,
  fields = c("symbol", "unit", "label"),
  expected = character(0),
  na = NA_character_,
  tables = TRUE,
  ...
)
}
\arguments{
\item{x}{model}

\item{fields}{data items to scavenge from control stream comments}

\item{expected}{parameters known from NONMEM output}

\item{na}{string to use for NA values when writing default metafile}

\item{tables}{whether to include table comments}

\item{...}{passed arguments}
}
\value{
data.frame
}
\description{
Extracts comments from model.
}
\examples{
library(magrittr)
options(project = system.file('project/model',package='nonmemica'))
1001 \%>\% as.model \%>\% comments
}
\seealso{
Other comments: 
\code{\link{comments.inits}()},
\code{\link{comments.items}()},
\code{\link{comments}()}
}
\concept{comments}
