% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/superset.R
\name{meta.character}
\alias{meta.character}
\title{Get Metadata for Character}
\usage{
\method{meta}{character}(x, simplify = TRUE, ...)
}
\arguments{
\item{x}{object}

\item{simplify}{logical: remove range information from guide text}

\item{...}{passed arguments}
}
\value{
data.frame
}
\description{
Gets metadata for character, treating it as a model name. Blends metadata from specfile with metadata from control stream, removing both exact duplicates as well as redefined values (with warning).
}
\examples{
library(magrittr)
options(project = system.file('project/model',package='nonmemica'))
1001 \%>\% meta
}
\seealso{
Other superset: 
\code{\link{generalize}()},
\code{\link{ignored}()},
\code{\link{meta.numeric}()},
\code{\link{metaplot.character}()},
\code{\link{metaplot.numeric}()},
\code{\link{metaplot_character}()},
\code{\link{metasuperset}()},
\code{\link{meta}()},
\code{\link{ninput.character}()},
\code{\link{ninput.numeric}()},
\code{\link{ninput}()},
\code{\link{shuffle}()},
\code{\link{superset.character}()},
\code{\link{superset.numeric}()},
\code{\link{superset}()},
\code{\link{superspec.character}()},
\code{\link{superspec.numeric}()},
\code{\link{superspec}()}
}
\concept{superset}
