% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/norm_tidy_dbf.R
\name{unique_identifier}
\alias{unique_identifier}
\title{Title: A modified unique identifier function for FLUOstar normalized data}
\usage{
unique_identifier(df)
}
\arguments{
\item{df}{A data frame with n number of rows}
}
\value{
A new data frame with the Cycle_Number attribute added.
}
\description{
Package creates a column called Cycle_Number and adds to the cleaned dbf data frame
}
\note{
The FLUOstar microplate reader runs in cycles with the number of cycles determined
by the experimenter. This function essentially counts the number of cycles and is a subordinate
function to the main function norm_tidy_dbf(). Also the function can be used as a standalone but the
only limitation is the column name will be Cycle_Number.
For a more generic version of this program, use the generic_identifier included.
}
\examples{
test_df <- as.data.frame(c(seq(40)))
colnames(test_df) <- "test"
unique_identifier(test_df)
}
\author{
Tingwei Adeck
}
