% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normfluordat.R
\name{normfluordat}
\alias{normfluordat}
\title{Title: Cleans and normalizes DAT files obtained from experiments using the FLUOstar Omega microplate reader (from BMG LABTECH).}
\usage{
normfluordat(
  dat,
  tnp,
  cycles,
  rows_used = NULL,
  cols_used = NULL,
  user_specific_labels = NULL
)
}
\arguments{
\item{dat}{A string ("dat_1.dat") if the file is found within the present working directory (pwd) OR a path pointing directly to a ".dat" file.}

\item{tnp}{A numeric value indicating the number of rows used. TNP is used as an acronym for Test, Negative, Positive.}

\item{cycles}{A numeric value indicating the number of cycles selected by the user when running the FLUOstar instrument.}

\item{rows_used}{A character vector of the rows used; ru = c('A','B','C').}

\item{cols_used}{A numeric vector of the columns used; cu = c(1,2,3).}

\item{user_specific_labels}{A character vector manually prepared by the user to denote the wells used on the microplate reader; usl = c('A1','B1','C1').}
}
\value{
A normalized data frame with an appended "Cycle_Number" attribute. The “Cycle_Number” attribute is the X-variable.
}
\description{
The simplest case scenario entails inputting the name or directory of a DAT file as a string,
the number of rows denoted by the tnp (test, negative, positive) parameter,
and the number of cycles (selected by the user when running the FLUOstar instrument).
The program takes these three baseline parameters, performs cleaning and normalization of the DAT file,
and then appends an attribute called “Cycle_Number” to the normalized data frame.
}
\note{
This function has less optimized space and time complexities than @seealso \code{\link[=normfluodat]{normfluodat()}}.
In real-time the difference in optimization is not noticeable.
This function also takes less parameters than the more optimized version of the function.
}
\examples{
fpath <- system.file("extdata", "dat_1.dat", package = "normfluodbf", mustWork = TRUE)
normalized_fluo_dat <- normfluordat(dat=fpath, tnp = 3, cycles = 40)
}
\seealso{
\code{\link[=normfluodat]{normfluodat()}}
}
\author{
Tingwei Adeck
}
