% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/features.R
\name{features}
\alias{features}
\alias{features.default}
\title{Extract locations of features from a 'not' object}
\usage{
features(object, ...)

\method{features}{default}(object, method = c("ic", "threshold"),
  penalty = c("sic", "aic", "user"), q.max = 25, penalty.fun, th, ...)
}
\arguments{
\item{object}{An object of 'not' class returned by \code{\link{not}}.}

\item{...}{Further arguments that can be passed to the penalty function.}

\item{method}{A method of choosing the best solution in \code{object$solution.path}. 
If \code{method="ic"}, model minimising a chosen information criterion is selected. 
If \code{method="threshold"}, model is selected based on thresholding (see references for more details).}

\item{penalty}{Name of the penalty function to be used if \code{method="ic"}. If \code{penalty="user"},
a user-defined penalty function has to be passed via \code{penalty.fun}.}

\item{q.max}{Maximum number of change-points allowed to be detected. Used only for \code{method="ic"}.}

\item{penalty.fun}{Used only if \code{penalty="user"}. A function includes at least  the following arguments: sample size \code{n}, number of parameters used in a model \code{n.param}, and \code{...}.
For examples of such functions, see \code{\link{aic.penalty}} and \code{\link{sic.penalty}}.}

\item{th}{Used only if \code{method="threshold"}. A positive real number.}
}
\value{
\item{th}{Value of the threshold used (if \code{method="threshold"}) or selected on the solution path (if \code{method="ic"}).}
\item{cpt}{Estimated locations of the change-points.}
\item{ic}{Values of the information criterion minimised in order to find an optimal solution on the path (only if \code{method="ic"} was used).}
}
\description{
The function applies user-specified stopping criteria to extract change-points from \code{object}
generated by \code{\link{not}}.
}
\details{
Denote by \eqn{T_{1}, \ldots, T_{N}}{T_1, ..., T_N} the elements on the solution path \code{object$solution.path}, 
each representing a set of change-points.
When (\code{method="ic"}), the returned set of change-points is the one that minimises
\deqn{-2\mbox{log-likelihood}(\code{object}, \code{cpt}=T_k)+\mbox{penalty}(\code{object\$n}, \code{n.param}, ...),}{-2 log-likelihood(object, cpt=T_k) + penalty(object\$n, n.param, ...),}
over all \eqn{k}{k} such that the number of change-points in \eqn{T_k}{T_k} is smaller than or equal \code{q.max}. The log-likelihood is computed using the \code{\link{logLik}} routine,
while the penalty function is computed with \code{\link{sic.penalty}} (\code{penalty="sic"}), \code{\link{aic.penalty}} (\code{penalty="aic"}) or a user-defined penalty function (\code{penalty="user"}).
}
\examples{
# **** Piecewisce-constant mean with Gaussian noise.
x <- c(rep(0, 100), rep(1,100)) + rnorm(100)
# *** identify potential locations of the change-points
w <- not(x, contrast = "pcwsConstMean")
# *** choose change-points using default settings
fo <- features(w)
# *** get the change-points
fo$cpt
# *** plot the SIC curve
plot(fo$ic)
}
\references{
R. Baranowski, Y. Chen, and P. Fryzlewicz (2016). Narrowest-Over-Threshold Change-Point Detection.  (\url{http://personal.lse.ac.uk/baranows/not/not.pdf})
}

