% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/replext_t5.R
\name{replext_t5_c1.2}
\alias{replext_t5_c1.2}
\title{Replicate and Extend Simulation Results for Paired Distributions with Different Variances}
\usage{
replext_t5_c1.2(
  M1 = 5,
  S1 = 1,
  M2 = 5,
  S2 = 3,
  Sk1 = 0,
  Sk2 = 0,
  correl = 0.8,
  n = c(3, 4, 5, 6, 7, 8, 9, 10, 15, 25),
  n_simulations = 10000,
  nboot = 1000,
  conf.level = 0.95
)
}
\arguments{
\item{M1}{Mean for the first group, default is 5.}

\item{S1}{Standard deviation for the first group, default is 1.}

\item{M2}{Mean for the second group, default is 5.}

\item{S2}{Standard deviation for the second group, default is 3.}

\item{Sk1}{Skewness parameter for the first group, default is 0 (normal distribution).}

\item{Sk2}{Skewness parameter for the second group, default is 0 (normal distribution).}

\item{correl}{Correlation between the two groups, default is 0.8.}

\item{n}{Vector of sample sizes for the paired groups.}

\item{n_simulations}{Number of simulations to run, default is 10,000.}

\item{nboot}{Number of bootstrap samples, default is 1000.}

\item{conf.level}{Confidence level for calculating p-value thresholds, default is 0.95.}
}
\value{
A data frame with columns for each sample size and
the proportions of significant p-values for each test (PT, NPBTT, WRST, PTT),
similar to 'replext_t5_c1.1' but with differing standard deviations for the groups.
}
\description{
This function is a wrapper around 'replext_t5_c1.1' and is specifically aimed
at replicating and extending simulation results from Table 5 cell 1.2 of the
paper by Dwivedi et al. (2017). It is tailored for paired distributions with
the option to use either normal or skew normal distributions, differing in
standard deviations between the two groups.
}
\examples{
replext_t5_c1.2(n = c(10), n_simulations = 1)

}
\references{
Dwivedi AK, Mallawaarachchi I, Alvarado LA. Analysis of small sample size
studies using nonparametric bootstrap test with pooled resampling method.
Stat Med. 2017 Jun 30;36(14):2187-2205. doi: 10.1002/sim.7263. Epub 2017 Mar 9. PMID: 28276584.
}
