% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/replext_ts3.R
\name{replext_ts3_c3.1}
\alias{replext_ts3_c3.1}
\title{Replicate and Extend Statistical Power Analysis for ANOVA with Diverse Skewness
Parameters}
\usage{
replext_ts3_c3.1(
  M1 = 5,
  S1 = 1,
  M2 = 6,
  S2 = 1,
  M3 = 7,
  S3 = 1,
  Sk1 = 0.8,
  Sk2 = 0.8,
  Sk3 = 1,
  n1 = c(2, 3, 4, 5, 6, 7, 8, 9, 10, 15, 25, 50, 100),
  n2 = c(2, 3, 4, 5, 6, 7, 8, 9, 10, 15, 25, 50, 100),
  n3 = c(2, 3, 4, 5, 6, 7, 8, 9, 10, 15, 25, 50, 100),
  n_simulations = 10000,
  nboot = 1000,
  conf.level = 0.95
)
}
\arguments{
\item{M1}{Mean for the first group, default is 5.}

\item{S1}{Standard deviation for the first group, default is 1.}

\item{M2}{Mean for the second group, default is 6.}

\item{S2}{Standard deviation for the second group, default is 1.}

\item{M3}{Mean for the third group, default is 7.}

\item{S3}{Standard deviation for the third group, default is 1.}

\item{Sk1}{Skewness parameter for the first group, default is 0.8.}

\item{Sk2}{Skewness parameter for the second group, default is 0.8.}

\item{Sk3}{Skewness parameter for the third group, default is 1.}

\item{n1}{Vector of sample sizes for the first group.}

\item{n2}{Vector of sample sizes for the second group.}

\item{n3}{Vector of sample sizes for the third group, must be the same length as n1 and n2.}

\item{n_simulations}{Number of simulations to run, default is 10,000.}

\item{nboot}{Number of bootstrap samples for the nonparametric bootstrap test, default is 1000.}

\item{conf.level}{Confidence level for calculating p-value thresholds, default is 0.95.}
}
\value{
A data frame with columns for each sample size combination (n1, n2, n3)
and the proportions of significant p-values for each test (ANOVA,
Kruskal-Wallis, Nonparametric Bootstrap F-test, Permutation F-test).
}
\description{
This function is a wrapper around \code{replext_ts2_c1.1}. The function is designed
to reproduce or extend the statistical power analysis for ANOVA (Analysis of
Variance) from Dwivedi et al. (2017) supplemental table 3, cell 3.1.
}
\examples{
replext_ts3_c3.1(n1 = c(10), n2 = c(10), n3 = c(10), n_simulations = 1)

}
\references{
Dwivedi AK, Mallawaarachchi I, Alvarado LA. Analysis of small sample size
studies using nonparametric bootstrap test with pooled resampling method.
Stat Med. 2017 Jun 30;36(14):2187-2205. doi: 10.1002/sim.7263. Epub 2017 Mar 9. PMID: 28276584.
}
\seealso{
\code{\link{replext_ts2_c1.1}}
}
