% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Plot.box.R
\name{Plot.box}
\alias{Plot.box}
\title{Box plots.}
\usage{
Plot.box(object)
}
\arguments{
\item{object}{a fitted model object from ncda() or a processed data set from ProcessData()}
}
\value{
Box plots.
}
\description{
Box plot of the input data set by treatments and time period.
}
\examples{
#Plot from analysis object
\donttest{
ARTIS_analysis <- ncda(emot_pqol~tx, ARTIS, intervention, homeid,
                       indicator = c("0","1"))
Plot.box(ARTIS_analysis)
}
skin_analysis <- ncda(score~tx, skin, intervention, subject,
                      indicator = c("control","treatment"))
Plot.box(skin_analysis)
# Plot from processed data set
ARTIS_result <- ProcessData(ARTIS, tx, intervention, homeid, symptoms_pqol,
                            indicator = c("0","1"))
skin_result <- ProcessData(skin, tx, intervention, subject, score,
                           indicator = c("control","treatment"))
Plot.box(ARTIS_result)
Plot.box(skin_result)
}
