% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paket_nph_1-9.R
\name{plot.mixpch}
\alias{plot.mixpch}
\title{Plot mixpch Objects}
\usage{
\method{plot}{mixpch}(x, fun = c("S", "F", "haz", "cumhaz"),
  add = FALSE, ylab = fun, xlab = "Time", ...)
}
\arguments{
\item{x}{an object of class \code{mixpch}.}

\item{fun}{character string in \code{c("S","F","haz","cumhaz")} indicating which function to plot. Select \code{"S"} for the survival function,
\code{"F"} for the distribution functin, \code{"haz"} for the hazard function or \code{"cumhaz"} for the cumulative hazard function.}

\item{add}{logical, indicates if the drawing should be added to an existing plot.}

\item{ylab}{label of the y-axis}

\item{xlab}{label of the x-axis}

\item{...}{further arguments passed to the plotting functions}
}
\description{
Plots survival and other functions stored in \code{mixpch} objects versus time.
}
\examples{
A <- pop_pchaz(Tint = c(0, 90, 1500),
  lambdaMat1 = matrix(c(0.2, 0.1, 0.4, 0.1), 2, 2) / 365,
 lambdaMat2 = matrix(c(0.5, 0.2, 0.6, 0.2), 2, 2) / 365,
 lambdaProg = matrix(c(0.5, 0.5, 0.4, 0.4), 2, 2) / 365,
 p = c(0.8, 0.2), 
 timezero = FALSE, discrete_approximation = TRUE)
plot(A)
plot(A, "haz", add = TRUE)

}
\seealso{
\code{\link{pchaz}}, \code{\link{subpop_pchaz}}, \code{\link{pop_pchaz}}
}
\author{
Robin Ristl, \email{robin.ristl@meduniwien.ac.at}
}
