% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oxy-gen.wgt.R
\name{gen.wgt}
\alias{gen.wgt}
\title{Weight Function Generation}
\usage{
gen.wgt(method = c("LR"), param, theta = 0.5)
}
\arguments{
\item{method}{a vector of text specifying the method(s). The method(s)
must be one or some of c(\code{"LR"}, \code{"FH"}, \code{"Wilcoxon"},
\code{"Tarone"},\code{"Maxcombo"},\code{"Maxcross"}).  Default: c("LR")}

\item{param}{a vector of length 2. If \code{FH} method is selected,
\eqn{\rho} and \eqn{\gamma} parameters must be provided, Default: 1}

\item{theta}{a value within (0,1). If method \code{Maxcross} is selected,
\code{theta} should be specified. See details. Default: 0.5}
}
\value{
a list of weight function(s).
}
\description{
Generate commonly used weight functions for \code{MaxLRtest}
function or \code{pwr2n.NPH} function
}
\details{
The weight function for Fleming-Harrington (FH) test is \eqn{S(t)^\rho(1-S(t)^\gamma)}.
If \code{FH} test is specified, both \eqn{\rho} and \eqn{\gamma} should be provided.
The weight for Tarone and Ware test is \eqn{y(t)^{1/2}}, where \eqn{y(t)} is number
of subjects at risk. The weight for Wilcoxon test is \eqn{y(t)}. See Klein (2003) for
more details about all those tests. Both Maxcombo test and test proposed by
Cheng and He (2021)
need four weight functions. Cheng's method is more sensitive in detecting
crossing hazards. A nuisance parameter \code{theta} is required to be
specified. Parameter \code{theta} represents the Cumulative Density Function
(CDF) at the crossing time point.
If the hazards crossing
occurs when few events occur yet, a small value should be chosen. The
default value is 0.5.

Function \code{MaxLRtest} supports different base functions including pooled
Kaplan-Meier (K-M) version of CDF functions rather than K-M survival functions.
Therefore, if a F(0,1) test is requested, the returned function is
\code{function(x) {x}}, where x denotes the estimated CDF for
\code{KM} base. All the supported
base functions are increasing over time.
}
\examples{
#logrank test
gen.wgt(method="LR")
# FH and logrank test
  fn <- gen.wgt(method=c("FH","LR"), param = c(1,1))
# maximum weighted logrank test proposed by Cheng, including weight
# for detecting crossing hazards
  wcross <- gen.wgt(method="Maxcross", theta = c(0.2))
}
\references{
Klein, J. P., & Moeschberger, M. L. (2003). Survival analysis: techniques for
censored and truncated data (Vol. 1230). New York: Springer.

Cheng, H., & He, J. (2021). A Maximum Weighted Logrank Test in Detecting
Crossing Hazards. arXiv preprint arXiv:2110.03833.
}
\seealso{
\code{\link{MaxLRtest}}, \code{\link{pwr2n.NPH}}
}
