% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nest_unite.R
\name{nest_unite}
\alias{nest_unite}
\title{Unite multiple columns into one in a column of nested data frames}
\usage{
nest_unite(
  .data,
  .nest_data,
  col,
  ...,
  sep = "_",
  remove = TRUE,
  na.rm = FALSE
)
}
\arguments{
\item{.data}{A data frame, data frame extension (e.g., a tibble), or a lazy
data frame (e.g., from dbplyr or dtplyr).}

\item{.nest_data}{A list-column containing data frames}

\item{col}{The name of the new column, as a string or symbol.

This argument is passed by expression and supports
\link[rlang:topic-inject]{quasiquotation} (you can unquote strings
and symbols). The name is captured from the expression with
\code{\link[rlang:defusing-advanced]{rlang::ensym()}} (note that this kind of interface where
symbols do not represent actual objects is now discouraged in the
tidyverse; we support it here for backward compatibility).}

\item{...}{Columns to unite.}

\item{sep}{Separator to use between values.}

\item{remove}{If \code{TRUE}, remove input columns from output data frame.}

\item{na.rm}{If \code{TRUE}, missing values will be removed prior to uniting
each value.}
}
\value{
An object of the same type as \code{.data}. Each object in the column \code{.nest_data}
will have a new column created as a combination of existing columns.
}
\description{
\code{nest_unite()} is used to combine multiple columns into one in a column of
nested data frames.
}
\details{
\code{nest_unite()} is a wrapper for \code{\link[tidyr:unite]{tidyr::unite()}} and maintains the functionality
of \code{unite()} within each nested data frame. For more information on \code{unite()}
please refer to the documentation in \href{https://tidyr.tidyverse.org/}{'tidyr'}.
}
\examples{
set.seed(123)
gm <- gapminder::gapminder 
gm_nest <- gm \%>\% tidyr::nest(country_data = -continent)

gm_nest \%>\% 
  nest_unite(.nest_data = country_data, 
             col = comb, 
             year, 
             pop)
}
\seealso{
Other tidyr verbs: 
\code{\link{nest_drop_na}()},
\code{\link{nest_extract}()},
\code{\link{nest_fill}()},
\code{\link{nest_replace_na}()},
\code{\link{nest_separate}()}
}
\concept{tidyr verbs}
