% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meanKinship.R
\name{meanKinship}
\alias{meanKinship}
\title{Calculates the mean kinship for each animal in a kinship matrix}
\usage{
meanKinship(kmat)
}
\arguments{
\item{kmat}{a numeric matrix of pairwise kinship coefficients.
Animal IDs are the row and column names.}
}
\value{
A named numeric vector of average kinship coefficients for each
animal ID. Elements are named with the IDs from the columns of kmat.
}
\description{
Part of Genetic Value Analysis
}
\details{
The mean kinship of animal \emph{i} is \deqn{MK_i = \Sigma f_ij / N},
in which the summation is over all animals, \emph{j}, including the kinship
of animal \emph{i} to itself.
}
\examples{
\donttest{
library(nprcgenekeepr)
ped <- nprcgenekeepr::qcPed
kmat <- kinship(ped$id, ped$sire, ped$dam, ped$gen)
head(meanKinship(kmat))
}

}
