% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rankSubjects.R
\name{rankSubjects}
\alias{rankSubjects}
\title{Ranks animals based on genetic value.}
\usage{
rankSubjects(rpt)
}
\arguments{
\item{rpt}{a list of data.frame {req. colnames: value} containing genetic
value data for the population. Dataframes separate out those animals that
are imports, those that have high genome uniqueness (gu > 10%), those that
have low mean kinship (mk < 0.25), and the remainder.}
}
\value{
A list of dataframes with value and ranking information added.
}
\description{
Part of Genetic Value Analysis
Adds a column to \code{rpt} containing integers from 1 to nrow, and provides
a value designation for each animal of "high value" or "low value"
}
\examples{
\donttest{
library(nprcgenekeepr)
finalRpt <- nprcgenekeepr::finalRpt
rpt <- rankSubjects(nprcgenekeepr::finalRpt)
rpt[["highGu"]][1, "value"]
rpt[["highGu"]][1, "rank"]
rpt[["lowMk"]][1, "value"]
rpt[["lowMk"]][1, "rank"]
rpt[["lowVal"]][1, "value"]
rpt[["lowVal"]][1, "rank"]
}

}
