#' Copyright(c) 2017-2024 R. Mark Sharp
#' This file is part of nprcgenekeepr
context("getFocalAnimalPed")

library(stringi)
test_that("getFocalAnimalPed recognizes no file and wrong file arguments", {
  expect_error(getFocalAnimalPed(), "\"fileName\" is missing, with no default")
  expect_error(suppressWarnings(getFocalAnimalPed(
    fileName = "breeding file.csv"
  )), "cannot open the connection")
})

source <- " generated by getFocalAnimalPed: "
qcPedXlsx <- system.file("testdata", "qcPed.xlsx",
  package = "nprcgenekeepr"
)
qcPedCsv <- system.file("testdata", "qcPed.csv",
  package = "nprcgenekeepr"
)
qcPedTxt <- system.file("testdata", "qcPed.txt",
  package = "nprcgenekeepr"
)
qcPedEmptyTxt <- system.file("testdata", "qcPedEmpty.txt",
  package = "nprcgenekeepr"
)
test_that(
  stri_c(
    "getFocalAnimalPed can open an Excel file fails to get ",
    "focal animals"
  ),
  {
    skip_if_not(Sys.info()[names(Sys.info()) == "user"] == "rmsharp")
    expect_true(
      stri_detect_fixed(capture.output(tryCatch(
        getFocalAnimalPed(fileName = qcPedXlsx),
        warning = function(wCond) {
          cat(paste0("Warning", source, wCond),
            name = "nprcgenekeepr"
          )
          return(NULL)
        },
        error = function(eCond) {
          cat(paste0("Error", source, eCond),
            name = "nprcgenekeepr"
          )
          return(NULL)
        }
      ))[[1L]], pattern = "Warning generated by getFocalAnimalPed")
    )
  }
)

test_that(
  stri_c(
    "getFocalAnimalPed can open a CSV file fails to get ",
    "focal animals"
  ),
  {
    skip_if_not(Sys.info()[names(Sys.info()) == "user"] == "rmsharp")
    expect_true(
      stri_detect_fixed(capture.output(tryCatch(
        getFocalAnimalPed(fileName = qcPedCsv),
        warning = function(wCond) {
          cat(paste0("Warning", source, wCond),
            name = "nprcgenekeepr"
          )
          return(NULL)
        },
        error = function(eCond) {
          cat(paste0("Error", source, eCond),
            name = "nprcgenekeepr"
          )
          return(NULL)
        }
      ))[[1L]], pattern = "Warning generated by getFocalAnimalPed")
    )
  }
)
test_that(
  stri_c(
    "getFocalAnimalPed can open a TXT file fails to get ",
    "focal animals"
  ),
  {
    skip_if_not(Sys.info()[names(Sys.info()) == "user"] == "rmsharp")
    expect_true(
      stri_detect_fixed(capture.output(tryCatch(
        getFocalAnimalPed(fileName = qcPedTxt),
        warning = function(wCond) {
          cat(paste0("Warning", source, wCond),
            name = "nprcgenekeepr"
          )
          return(NULL)
        },
        error = function(eCond) {
          cat(paste0("Error", source, eCond),
            name = "nprcgenekeepr"
          )
          return(NULL)
        }
      ))[[1L]], pattern = "Warning generated by getFocalAnimalPed")
    )
  }
)
test_that(
  stri_c("getFocalAnimalPed handles empty pedigree file"),
  {
    skip_if_not(Sys.info()[names(Sys.info()) == "user"] == "rmsharp")
    expect_warning(
      result <- getFocalAnimalPed(fileName = qcPedEmptyTxt),
      "The nprcgenekeepr configuration file is missing."
    )
    expect_length(result, 9L)
  }
)
