% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nproc.R
\name{nproc}
\alias{nproc}
\title{Calculate the Neyman-Pearson ROC}
\usage{
nproc(x = NULL, y, method = c("logistic", "penlog", "svm", "randomforest",
  "lda", "nb", "ada", "custom"), score = NULL, alphalist = seq(from = 0.01,
  to = 0.99, by = 0.01), delta = 0.05, split = TRUE, cv = FALSE,
  fold = 5, loc.prob = NULL, n.cores = 1)
}
\arguments{
\item{x}{n * p observation matrix. n observations, p covariates.}

\item{y}{n 0/1 observatons.}

\item{method}{classification method.
\itemize{
\item logistic: \link{glm} function with family = 'binomial'
\item penlog: \code{\link[glmnet]{glmnet}} in \code{glmnet} package
\item svm: \code{\link[e1071]{svm}} in \code{e1071} package
\item randomforest: \code{\link[randomForest]{randomForest}} in \code{randomForest} package
\item lda: \code{\link[MASS]{lda}} in \code{MASS} package
\item nb: \code{\link[e1071]{naiveBayes}} in \code{e1071} package
\item ada: \code{\link[ada]{ada}} in \code{ada} package
\item custom: a custom classifier. score vector needed.
}}

\item{score}{score vector corresponding to y. Required when method  = 'custom'.}

\item{alphalist}{the sequence of type I error values. Default = seq(from=0,to=1,by=0.01).}

\item{delta}{the violation rate of the type I error. Default = 0.05.}

\item{split}{whether the class 0 sample is split into two parts.}

\item{cv}{whether cross-validation is performed for calculating the roc curve.}

\item{fold}{number of folds for the cross-validation. Default = 5.}

\item{loc.prob}{the precalculated threshold locations in probability. Default = NULL.}

\item{n.cores}{number of cores used for parallel computing. Default = 1.}
}
\description{
\code{nproc} calculate the Neyman-Pearson ROC
curve for a given sequence of type I error values.
}
\examples{
n = 1000
x = matrix(rnorm(n*2),n,2)
c = 1+3*x[,1]
y = rbinom(n,1,1/(1+exp(-c)))
#fit = nproc(x, y, method = 'svm')
#fit2 = nproc(x, y, method = 'svm', cv = TRUE)
fit3 = nproc(x, y, method = 'penlog')
#fit3 = nproc(x, y, method = 'penlog',  n.cores = 2)
#In practice, replace 2 by the number of cores available 'detectCores()'
#fit4 = nproc(x, y, method = 'penlog', n.cores = detectCores())

#Testing the custom method for nproc.
#fit = npc(x, y, method = 'lda', split = FALSE,  n.cores = 2) #use npc to get score list.
#obj = nproc(x = NULL, y = fit$y, method = 'custom', split = FALSE,
#score = fit$score,  n.cores = 2)
}
\seealso{
\code{\link{npc}}
}

