% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.npc.R
\name{predict.npc}
\alias{predict.npc}
\title{Predicting the outcome of a set of new observations using the fitted npc
object.}
\usage{
\method{predict}{npc}(object, newx = NULL, ...)
}
\arguments{
\item{object}{fitted npc object using \code{npc}.}

\item{newx}{a set of new observations.}

\item{...}{additional arguments.}
}
\value{
A list containing the predicted label and score.
\item{pred.label}{Predicted label vector.}
\item{pred.score}{Predicted score vector.}
}
\description{
Predicting the outcome of a set of new observations using the fitted npc
object.
}
\examples{
n = 1000
x = matrix(rnorm(n*2),n,2)
c = 1+3*x[,1]
y = rbinom(n,1,1/(1+exp(-c)))
xtest = matrix(rnorm(n*2),n,2)
ctest = 1+3*xtest[,1]
ytest = rbinom(n,1,1/(1+exp(-ctest)))

##Use logistic classifier and the default type I error control with alpha=0.05
#fit = npc(x, y, method = 'logistic')
#pred = predict(fit,xtest)
#fit.score = predict(fit,x)
#accuracy = mean(pred$pred.label==ytest)
#cat('Overall Accuracy: ',  accuracy,'\\n')
#ind0 = which(ytest==0)
#ind1 = which(ytest==1)
#typeI = mean(pred$pred.label[ind0]!=ytest[ind0]) #type I error on test set
#cat('Type I error: ', typeI, '\\n')
#typeII = mean(pred$pred.label[ind1]!=ytest[ind1]) #type II error on test set
#cat('Type II error: ', typeII, '\\n')
}
\seealso{
\code{\link{npc}} and \code{\link{nproc}}
}

