% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nse.R
\name{nse.geyer}
\alias{nse.geyer}
\title{Geyer estimator}
\usage{
nse.geyer(x, type = c("iseq", "bm", "obm", "iseq.bm"), nbatch = 30,
  iseq.type = c("pos", "dec", "con"))
}
\arguments{
\item{x}{A numeric vector.}

\item{type}{The type which can be either \code{"iseq"}, \code{"bm"}, \code{"obm"} or \code{"iseq.bm"}.
See *Details*. Default is \code{type = "iseq"}.}

\item{nbatch}{Number of batches when \code{type = "bm"} and \code{type = "iseq.bm"}. Default is \code{nbatch = 30}.}

\item{iseq.type}{Constraints on function: \code{"pos"} for nonnegative, \code{"dec"} for nonnegative
and nonincreasing, and \code{"con"} for nonnegative, nonincreasing, and convex. Default is \code{iseq.type = "pos"}.}
}
\value{
The NSE estimator.
}
\description{
Function which calculates the numerical standard error with the method of Geyer (1992).
}
\details{
The type \code{"iseq"} gives the positive intial sequence estimator, \code{"bm"} is the batch mean estimator,
\code{"obm"} is the overlapping batch mean estimator and \code{"iseq.bm"} is a combination of \code{"iseq"} and \code{"bm"}.
}
\note{
\code{nse.geyer} relies on the packages \code{\link{mcmc}} and \code{\link{mcmcse}}; see
the documentation of these packages for more details.
}
\examples{
n    = 1000
ar   = 0.9
mean = 1
sd   = 1
set.seed(1234)
x = as.vector(arima.sim(n = n, list(ar = ar), sd = sd) + mean)
nse.geyer(x = x, type = "bm", nbatch = 30)
nse.geyer(x = x, type = "obm", nbatch = 30)
nse.geyer(x = x, type = "iseq", iseq.type = "pos")
nse.geyer(x = x, type = "iseq.bm", iseq.type = "con")
}
\references{
Geyer, C.J. (1992).
Practical Markov chain Monte Carlo.
\emph{Statistical Science} \bold{7}(4),  .473-483.
}
\author{
David Ardia and Keven Bluteau
}
