% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nsrr_datasets.R
\name{nsrr_datasets}
\alias{nsrr_datasets}
\alias{nsrr_dataset}
\alias{nsrr_dataset_files}
\title{NSRR data sets}
\usage{
nsrr_datasets(token = nsrr_token(), page = NULL)

nsrr_dataset(dataset = NULL, token = nsrr_token())

nsrr_dataset_files(dataset = NULL, path = NULL, token = nsrr_token())
}
\arguments{
\item{token}{Token for NSRR resources.  Found at
\url{https://sleepdata.org/token}}

\item{page}{which page to grab.  Increment over successive requests to
retrieve all datasets. A request that return NULL or a number of datasets
less than 18 indicates the last page.}

\item{dataset}{a dataset \code{"slug"}, one from
\code{\link{nsrr_datasets}}}

\item{path}{a folder or file path inside the dataset}
}
\value{
A \code{data.frame} of the data sets and their endpoints
}
\description{
NSRR data sets
}
\examples{
df = nsrr_datasets()
if (attributes(df)$status_code == 200) {
testthat::expect_is(df, "data.frame")
slugs = c("abc", "bestair", "chat", "ccshs", "cfs",
"heartbeat", "hchs", "homepap", "haassa", "learn")
testthat::expect_true(all(slugs \%in\% df$slug))
}
nsrr_dataset(dataset = "shhs", token = "")
dataset = "shhs"
token = NULL
df = nsrr_dataset_files(dataset)
ddf = nsrr_dataset_files(dataset, path = df$full_path[1])


dataset = "shhs"
token = NULL
df = nsrr_dataset_files(dataset)
nsrr_dataset_files("wecare")

testthat::expect_error(nsrr_dataset_files(), "one data")
testthat::expect_error(nsrr_dataset_files(c("shhs", "chat")), "one data")
}
