% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{nsw}
\alias{nsw}
\alias{act}
\alias{lhi}
\alias{jbt}
\alias{sydney}
\title{Outlines of New South Wales and relevant territories.}
\format{
An object of class \code{sfc_MULTIPOLYGON} (inherits from \code{sfc}) of length 1.

An object of class \code{sfc_MULTIPOLYGON} (inherits from \code{sfc}) of length 1.

An object of class \code{sfc_MULTIPOLYGON} (inherits from \code{sfc}) of length 1.

An object of class \code{sfc_MULTIPOLYGON} (inherits from \code{sfc}) of length 1.

An object of class \code{sfc_POLYGON} (inherits from \code{sfc}) of length 1.
}
\source{
Australian Bureau of Statistics. "Australian Statistical Geography Standard (ASGS) Edition 3." ABS, Jul2021-Jun2026,
\url{https://www.abs.gov.au/statistics/standards/australian-statistical-geography-standard-asgs-edition-3/jul2021-jun2026}, accessed 27 September 2022.

The original dataset is published under the \href{https://creativecommons.org/licenses/by/4.0/}{Creative Commons Attribution 4.0 International} licence, © Commonwealth of Australia 2021.
}
\usage{
nsw

act

lhi

jbt

sydney
}
\description{
Lord Howe Island is administratively part of NSW, but as it is a small
island some 600 km off the coast, it is frequently omitted from maps of NSW.
}
\details{
The Australian Capital Territory is an enclave within NSW, and Jervis Bay
Territory is a small Australian territory on the coast, surrounded by NSW.
Neither are NSW territory, but they affect the shape of NSW's outline and are
sometimes useful to include in maps alongside NSW due to their locations.

The geometry for \code{nsw} has been simplified with a tolerance of 750 m to
reduce the level of detail, whereas the territories maintain their full
resolution. \code{sydney} is simplified with a 500 m tolerance.
}
\section{Functions}{
\itemize{
\item \code{nsw}: External state boundary excluding LHI but including ACT and JBT.

\item \code{act}: Australian Capital Territory boundary.

\item \code{lhi}: Lord Howe Island boundary.

\item \code{jbt}: Jervis Bay Territory boundary.

\item \code{sydney}: Greater Sydney boundary.

}}
\seealso{
\code{\link[=outline]{outline()}}
}
\keyword{datasets}
