% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nsNegBinom.R
\name{Neutrosophic Negative Binomial}
\alias{Neutrosophic Negative Binomial}
\alias{dnsNegBinom}
\alias{pnsNegBinom}
\alias{qnsNegBinom}
\alias{rnsNegBinom}
\title{Neutrosophic Negative Binomial Distribution}
\usage{
dnsNegBinom(x, size, prob)

pnsNegBinom(q, size, prob, lower.tail = TRUE)

qnsNegBinom(p, size, prob)

rnsNegBinom(n, size, prob)
}
\arguments{
\item{x}{a vector or matrix of observations for which the pdf needs to be computed.}

\item{size}{number of trials (zero or more), which must be a positive interval.}

\item{prob}{probability of success on each trial, \eqn{0 < \code{prob} < 1}.}

\item{q}{a vector or matrix of quantiles for which the cdf needs to be computed.}

\item{lower.tail}{logical; if TRUE (default), probabilities are
\eqn{P(X \leq x)}; otherwise, \eqn{P(X >x)}.}

\item{p}{a vector or matrix of probabilities for which the quantile needs to be computed.}

\item{n}{number of random values to be generated.}
}
\value{
\code{dnsNegBinom} gives the probability mass function

 \code{pnsNegBinom} gives the distribution function

 \code{qnsNegBinom} gives the quantile function

 \code{rnsNegBinom} generates random variables from the Negative Binomial Distribution.
}
\description{
Density, distribution function, quantile function and random
generation for the neutrosophic Negative Binomial distribution with
parameters \code{size} = \eqn{r_N} and \code{prob} = \eqn{p_N}.
}
\details{
The neutrosophic negative binomial distribution with parameters \eqn{r_N} and \eqn{p_N}
has the density
\deqn{\left(\begin{array}{c} r_N+x-1 \\ x \end{array}\right) p_N^{r_N}\left(1-p_N\right)^{x}}
for \eqn{r_N \in \{1, 2, \ldots\}} and \eqn{p_N \in (p_L, p_U)} which must be \eqn{0<p_N<1}
and \eqn{x \in \{0, 1, 2, \ldots\}}.
}
\examples{
dnsNegBinom(x = 1, size = 2, prob = c(0.5, 0.6))
pnsNegBinom(q = 1, size = 2, prob = c(0.5, 0.6))
qnsNegBinom(p = c(0.25, 0.5, 0.75), size = 2, prob = c(0.5, 0.6))
rnsNegBinom(n = 10, size = 2, prob = c(0.6, 0.6))
}
\references{
Granados, C. (2022).
       Some discrete neutrosophic distributions with neutrosophic parameters based on neutrosophic random variables.
        \emph{Hacettepe Journal of Mathematics and Statistics}, 51(5), 1442-1457.
}
