% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_num.R
\name{f_num}
\alias{f_num}
\alias{ff_num}
\title{Format Digits}
\usage{
f_num(
  x,
  digits = getOption("numformdigits"),
  p,
  s,
  pad.char = NA,
  zero = NULL,
  ...
)

ff_num(...)
}
\arguments{
\item{x}{A vector of numbers (or string equivalents).}

\item{digits}{The number of digits to use.  Defaults to 1.  Can be set
globally via: \code{options(numformdigits = n)} where n is the number of
digits beyond the decimal point to include.}

\item{p}{A string to paste at the beginning of the output from \code{f_num}.}

\item{s}{A string to paste at the end of the output from \code{f_num}.}

\item{pad.char}{A character to use for leading padding if lengths of output
are unequal.}

\item{zero}{A value to insert in for zero values.}

\item{\ldots}{ignored.}
}
\value{
Returns a string of publication ready digits.
}
\description{
Remove leading zeros and standardize number of digits.  A workhorse for the
\pkg{numform} package.
}
\examples{
f_num(c(0.0, 0, .2, -00.02, 1.122222, pi))
f_num(rnorm(10))
f_num(rnorm(20, 100, 200), 0)
f_num(c("-0.23", "0", ".23"))

## Percents
f_num(c(30, 33.45, .1), 3, s="\%")

## Money
f_num(c(30, 33.45, .1), 2, p="$")

## Units
f_num(c(30, 33.45, .1), 2, s=" in.<sup>2</sup>")
f_num(c(30, 33.45, .1), 2, p="&Chi;<sup>2</sup>=")

\dontrun{
library(dplyr)

is.int <- function(x) !all(x \%\% 1 == 0)

mtcars \%>\%
    mutate_if(.funs = f_num, is.int)

df <- data.frame(x = -10:10, y = (-10:10)/10)

ggplot(df, aes(x, y))+
    geom_point() +
    scale_y_continuous(labels = ff_num(zero = 0))
}
}
