% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getParticipant.R
\name{getParticipant}
\alias{getParticipant}
\title{Gets information about a single participant.}
\usage{
getParticipant(labbcat.url, id, layer.ids)
}
\arguments{
\item{labbcat.url}{URL to the LaBB-CAT instance}

\item{id}{A participant ID}

\item{layer.ids}{A vector of layer IDs corresponding to participant attributes,
eg. c('participant_gender', 'participant_year_of_birth')}
}
\value{
A named list of representing the participant and its attributes, with members:
\itemize{
 \item{\emph{id} The participant's unique internal database ID}
 \item{\emph{label} The ID (name) of the participant}
 \item{\emph{annotations} A named list of participant attributes
 e.g. the label of the participant's 'gender' attribute would be:
 participant$annotations$participant_gender$label}
}
}
\description{
Returns a nested named list with the participant information, including the given
participant attributes.
}
\examples{
\dontrun{
## define the LaBB-CAT URL
labbcat.url <- "https://labbcat.canterbury.ac.nz/demo/"

## Get the gender and year of birth of AP511_MikeThorpe
participant <- getParticipant(labbcat.url, "AP511_MikeThorpe",
                  c("participant_gender", "participant_year_of_birth"))

print(paste("ID:", participant$label,
            "Gender:", participant$annotations$participant_gender$label,
            "YOB:", participant$annotations$participant_year_of_birth$label))
}

}
\seealso{
\code{\link{getParticipantAttributes}}
  \code{\link{saveParticipant}}
  \code{\link{deleteParticipant}}
}
\keyword{transcript}
