% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_pc_vs.R
\name{plot_pc_vs}
\alias{plot_pc_vs}
\title{Plot PC loadings in vowel space}
\usage{
plot_pc_vs(vowel_data, pca_obj, pc_no = 1, is_sig = FALSE)
}
\arguments{
\item{vowel_data}{A dataframe whose first four columns are speaker ids,
vowel ids, F1 values, and F2 values.}

\item{pca_obj}{The result of a call to \code{prcomp()}, \code{princomp()} or \code{pca_test()}.}

\item{pc_no}{An integer, indicating which PC to plot (default is PC1).}

\item{is_sig}{A boolean, indicating whether only 'significant' loadings,
according to \code{pca_test} should be plotted (only works with objects of class
\code{pca_test_results}).}
}
\value{
a \code{ggplot} object.
}
\description{
Plot loadings from a PCA analysis carried out on vocalic data. Vowel
positions mean values are at the mean with arrows indicating loadings.
Loadings are
multiplied by the standard deviation, by vowel, of the initial input data.
This is OK for getting a quick, intuitive, interpretation of what the PCs
mean in the vowel space. When using a model-to-PCA pipeline, it is not
recommended to use these plots directly in publications as the models should
more reliably control variation in vocalic readings than taking the standard
mean and standard deviation.
}
\examples{
  onze_pca <- prcomp(onze_intercepts |> dplyr::select(-speaker), scale=TRUE)
  # Default is to plot PC1
  plot_pc_vs(onze_vowels, onze_pca)
  # Or plot another PC with `pc_no`
  plot_pc_vs(onze_vowels, onze_pca, pc_no = 3)
}
